/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.movingworld.common.util;

import com.google.common.collect.HashBiMap;
import darkevilmac.movingworld.common.chunk.LocatedBlock;
import java.util.ArrayList;
import net.minecraft.world.ChunkPosition;

public class LocatedBlockList
extends ArrayList<LocatedBlock> {
    private HashBiMap<ChunkPosition, LocatedBlock> posMap;

    public LocatedBlockList() {
        this.posMap = HashBiMap.create();
    }

    public LocatedBlockList(int initialSize) {
        super(initialSize);
    }

    @Override
    public boolean add(LocatedBlock locatedBlock) {
        if (!this.posMap.containsKey((Object)locatedBlock.coords)) {
            this.posMap.put((Object)locatedBlock.coords, (Object)locatedBlock);
        }
        return super.add(locatedBlock);
    }

    @Override
    public void add(int index, LocatedBlock locatedBlock) {
        if (!this.posMap.containsKey((Object)locatedBlock.coords)) {
            this.posMap.put((Object)locatedBlock.coords, (Object)locatedBlock);
        }
        super.add(index, locatedBlock);
    }

    public LocatedBlock getLBOfPos(ChunkPosition pos) {
        return (LocatedBlock)this.posMap.get((Object)pos);
    }

    public boolean containsLBOfPos(ChunkPosition pos) {
        return this.posMap.containsKey((Object)pos);
    }

    public ArrayList<LocatedBlockList> getSplitList(int segments) {
        int chunkLength = (int)Math.ceil(this.size() / segments);
        ArrayList<LocatedBlockList> result = new ArrayList<LocatedBlockList>(segments);
        if (chunkLength != 1) {
            LocatedBlockList thisClone = (LocatedBlockList)this.clone();
            LocatedBlockList currentIndex = new LocatedBlockList();
            for (LocatedBlock lb : thisClone) {
                currentIndex.add(lb);
                if (currentIndex.size() != chunkLength) continue;
                result.add(currentIndex);
                currentIndex = new LocatedBlockList();
            }
            if (currentIndex.size() > 0) {
                result.add(currentIndex);
            }
        } else {
            result.add(this);
        }
        return result;
    }
}

