/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.newradicalbotany.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.technicpack.newradicalbotany.NewRadicalBotany;

public class ItemRadicalFertilizer
extends Item {
    private Object botaniaClientProxy = null;
    private Method wispFxMethod = null;
    private IIcon[] icons = new IIcon[4];
    private static final StringBuilder allFlowersBuilder = new StringBuilder();

    public ItemRadicalFertilizer() {
        try {
            Class botaniaClientProxy = NewRadicalBotany.proxy.getBotaniaClientProxyClass();
            if (botaniaClientProxy != null) {
                this.botaniaClientProxy = NewRadicalBotany.proxy.initializeBotaniaProxy(botaniaClientProxy);
            }
            if (this.botaniaClientProxy != null) {
                this.wispFxMethod = botaniaClientProxy.getMethod("wispFX", World.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            }
        }
        catch (ClassNotFoundException ex) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        for (int i = 0; i < 4; ++i) {
            this.icons[i] = register.func_94245_a("newradicalbotany:fertilizer" + Integer.toString(i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int p_77618_1_, int p_77618_2_) {
        return p_77618_2_ >= 4 ? this.icons[0] : this.icons[p_77618_2_];
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int pass) {
        int[] flowers = this.getFlowerArray(itemStack);
        if (flowers != null && flowers.length > 0 && flowers.length <= 4) {
            return MapColor.func_151644_a((int)flowers[pass %= flowers.length]).field_76291_p;
        }
        switch (pass) {
            case 1: {
                return 3832868;
            }
            case 2: {
                return 10305042;
            }
            case 3: {
                return 10326696;
            }
        }
        return 8574837;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean advanced) {
        info.add("");
        int[] flowers = this.getFlowerArray(stack);
        if (flowers == null || flowers.length == 0) {
            String allFlowers = StatCollector.func_74838_a((String)"gui.newradicalbotany.fertilizer.all");
            allFlowersBuilder.delete(0, allFlowersBuilder.length());
            for (int i = 0; i < allFlowers.length(); ++i) {
                int color = player.field_70170_p.field_73012_v.nextInt(15) + 1;
                allFlowersBuilder.append("\u00a7");
                allFlowersBuilder.append(Integer.toHexString(color));
                allFlowersBuilder.append(allFlowers.charAt(i));
            }
            info.add(allFlowersBuilder.toString());
            return;
        }
        info.add(StatCollector.func_74838_a((String)"gui.newradicalbotany.fertilizer.some"));
        for (int i = 0; i < flowers.length; ++i) {
            info.add(" \u00a79* \u00a7" + Integer.toHexString(this.blockColorToTextColor(flowers[i])) + StatCollector.func_74838_a((String)("tile.botania:flower" + Integer.toString(flowers[i]) + ".name")));
        }
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        int range = 3;
        Block botaniaFlower = Block.func_149684_b((String)"Botania:flower");
        if (botaniaFlower == null) {
            return false;
        }
        if (!world.field_72995_K) {
            ArrayList<ChunkCoordinates> validCoords = new ArrayList<ChunkCoordinates>();
            for (int i = -4; i < 3; ++i) {
                for (int j = -4; j < 3; ++j) {
                    for (int k = 2; k >= -2; --k) {
                        int newX = x + i + 1;
                        int newY = y + k + 1;
                        int newZ = z + j + 1;
                        if (!world.func_147437_c(newX, newY, newZ) || world.field_73011_w.field_76576_e && y >= 255 || !botaniaFlower.func_149718_j(world, newX, newY, newZ)) continue;
                        validCoords.add(new ChunkCoordinates(newX, newY, newZ));
                    }
                }
            }
            int flowerCount = Math.min(validCoords.size(), world.field_73012_v.nextBoolean() ? 3 : 4);
            for (int i = 0; i < flowerCount; ++i) {
                ChunkCoordinates coords = (ChunkCoordinates)validCoords.get(world.field_73012_v.nextInt(validCoords.size()));
                validCoords.remove(coords);
                world.func_147465_d(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, botaniaFlower, this.getFlowerColor(itemStack, world.field_73012_v), 3);
            }
            --itemStack.field_77994_a;
        } else if (this.wispFxMethod != null && this.botaniaClientProxy != null) {
            for (int i = 0; i < 15; ++i) {
                double fxX = (double)(x - 3 + world.field_73012_v.nextInt(7)) + Math.random();
                double fxY = y + 1;
                double fxZ = (double)(z - 3 + world.field_73012_v.nextInt(7)) + Math.random();
                float red = (float)Math.random();
                float green = (float)Math.random();
                float blue = (float)Math.random();
                try {
                    this.wispFxMethod.invoke(this.botaniaClientProxy, world, fxX, fxY, fxZ, Float.valueOf(red), Float.valueOf(green), Float.valueOf(blue), Float.valueOf(0.15f + (float)Math.random() * 0.25f), Float.valueOf(-((float)Math.random()) * 0.1f - 0.05f));
                    continue;
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return true;
    }

    private int getFlowerColor(ItemStack stack, Random random) {
        int[] flowers = this.getFlowerArray(stack);
        if (flowers != null && flowers.length != 0) {
            return flowers[random.nextInt(flowers.length)];
        }
        return random.nextInt(16);
    }

    private int[] getFlowerArray(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("Flowers", 11)) {
            return tag.func_74759_k("Flowers");
        }
        return null;
    }

    private int blockColorToTextColor(int color) {
        switch (color) {
            case 0: {
                return 15;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 13;
            }
            case 3: {
                return 9;
            }
            case 4: {
                return 14;
            }
            case 5: {
                return 10;
            }
            case 6: {
                return 13;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 11;
            }
            case 10: {
                return 5;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 6;
            }
            case 13: {
                return 2;
            }
            case 14: {
                return 12;
            }
            case 15: {
                return 0;
            }
        }
        return 7;
    }
}

