/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.purplepanic;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.technicpack.purplepanic.PanicPatch;
import org.apache.commons.io.FileUtils;

@Mod(modid="purplepanic", version="1.0.6", name="Purple Panic")
public class PurplePanicMod {
    public static final String MODID = "purplepanic";
    public static final String VERSION = "1.0.6";
    public static final String NAME = "Purple Panic";
    static int genX = -972;
    static int genY = 157;
    static int genZ = -1022;
    static String schematic = "CheatHub";

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
        if (minecraftserver == null) {
            throw new RuntimeException("Couldn't get the instance of MinecraftServer");
        }
        World world = minecraftserver.func_130014_f_();
        if (world == null || world.field_73011_w == null || world.field_73011_w.field_76574_g != 0) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        FMLLog.info((String)"Purple Panic Load World", (Object[])new Object[0]);
        File testFile = new File(world.func_72860_G().func_75765_b(), "purplepanic.dat");
        int currentVersion = 0;
        if (testFile.exists()) {
            String versionStr = "0";
            try {
                versionStr = FileUtils.readFileToString((File)testFile);
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (versionStr.equals("done")) {
                currentVersion = 1;
            } else {
                try {
                    currentVersion = Integer.parseInt(versionStr);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
        if (currentVersion < 1) {
            new PanicPatch(-972, 157, -1022, "CheatHub").execute(minecraftserver);
            new PanicPatch(555, 241, 2077, "Thyrork").execute(minecraftserver);
        }
        if (currentVersion < 2) {
            new PanicPatch(1013, 119, 2009, "KeyHolder").execute(minecraftserver);
            new PanicPatch(-984, 153, -1017, "FixScanner").execute(minecraftserver);
        }
        if (currentVersion < 3) {
            FMLLog.info((String)"Scanning customnpc's folder for evidence of game completion.", (Object[])new Object[0]);
            File worldDir = world.func_72860_G().func_75765_b();
            if (worldDir.exists()) {
                File customNpcsDir = new File(worldDir, "customnpcs");
                if (customNpcsDir.exists()) {
                    File playerDataDir = new File(customNpcsDir, "playerdata");
                    if (playerDataDir.exists()) {
                        int dialogStatus = this.enumeratePlayerDir(playerDataDir);
                        switch (dialogStatus) {
                            case 43: {
                                new PanicPatch(829, 80, 802, "Victory").execute(minecraftserver);
                                break;
                            }
                            case 44: {
                                new PanicPatch(1295, 80, 1524, "Victory").execute(minecraftserver);
                                break;
                            }
                            case 45: {
                                new PanicPatch(564, 90, 1181, "Victory").execute(minecraftserver);
                            }
                        }
                    } else {
                        FMLLog.info((String)("Could not find " + playerDataDir.getAbsolutePath()), (Object[])new Object[0]);
                    }
                } else {
                    FMLLog.info((String)("Could not find " + customNpcsDir.getAbsolutePath()), (Object[])new Object[0]);
                }
            } else {
                FMLLog.info((String)("Could not find " + worldDir.getAbsolutePath()), (Object[])new Object[0]);
            }
            FMLLog.info((String)"Finished scanning.", (Object[])new Object[0]);
        }
        try {
            FileUtils.writeStringToFile((File)testFile, (String)"3");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        FMLLog.info((String)"PurplePanic done loading", (Object[])new Object[0]);
    }

    private int enumeratePlayerDir(File playerDir) {
        Iterator files = FileUtils.iterateFiles((File)playerDir, (String[])new String[]{"json"}, (boolean)true);
        Gson gson = new Gson();
        FMLLog.info((String)("Scanning " + playerDir.getAbsolutePath()), (Object[])new Object[0]);
        while (files.hasNext()) {
            File file = (File)files.next();
            try {
                String fileContents = FileUtils.readFileToString((File)file);
                JsonObject object = (JsonObject)gson.fromJson(fileContents, JsonObject.class);
                FMLLog.info((String)("Scanning " + object.get("PlayerName").getAsString()), (Object[])new Object[0]);
                if (!object.has("DialogData")) continue;
                JsonArray array = object.getAsJsonArray("DialogData");
                for (JsonElement element : array) {
                    int dialogNumber;
                    JsonObject dialog;
                    if (!element.isJsonObject() || !(dialog = element.getAsJsonObject()).has("Dialog") || (dialogNumber = dialog.get("Dialog").getAsInt()) < 43 || dialogNumber > 45) continue;
                    FMLLog.info((String)"Found completed game.", (Object[])new Object[0]);
                    return dialogNumber;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return 0;
    }
}

