/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol;

import com.khorn.terraincontrol.BiomeIds;
import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.BiomeLoadInstruction;
import com.khorn.terraincontrol.configuration.ConfigProvider;
import com.khorn.terraincontrol.configuration.WorldSettings;
import com.khorn.terraincontrol.customobjects.CustomObjectStructureCache;
import com.khorn.terraincontrol.exception.BiomeNotFoundException;
import com.khorn.terraincontrol.generator.biome.BiomeGenerator;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.NamedBinaryTag;
import com.khorn.terraincontrol.util.minecraftTypes.TreeType;
import java.util.Collection;
import java.util.Random;

public interface LocalWorld {
    public LocalBiome createBiomeFor(BiomeConfig var1, BiomeIds var2);

    public int getMaxBiomesCount();

    public int getMaxSavedBiomesCount();

    public int getFreeBiomeId();

    public LocalBiome getBiomeById(int var1) throws BiomeNotFoundException;

    public LocalBiome getBiomeByIdOrNull(int var1);

    public LocalBiome getBiomeByName(String var1) throws BiomeNotFoundException;

    public Collection<? extends BiomeLoadInstruction> getDefaultBiomes();

    public BiomeGenerator getBiomeGenerator();

    public LocalBiome getBiome(int var1, int var2) throws BiomeNotFoundException;

    public LocalBiome getSavedBiome(int var1, int var2) throws BiomeNotFoundException;

    public LocalBiome getCalculatedBiome(int var1, int var2);

    public void prepareDefaultStructures(int var1, int var2, boolean var3);

    public void PlaceDungeons(Random var1, int var2, int var3, int var4);

    public boolean PlaceTree(TreeType var1, Random var2, int var3, int var4, int var5);

    public boolean placeDefaultStructures(Random var1, ChunkCoordinate var2);

    public void replaceBlocks(ChunkCoordinate var1);

    public void placePopulationMobs(LocalBiome var1, Random var2, ChunkCoordinate var3);

    public void startPopulation(ChunkCoordinate var1);

    public void endPopulation();

    public LocalMaterialData getMaterial(int var1, int var2, int var3);

    public boolean isEmpty(int var1, int var2, int var3);

    public void setBlock(int var1, int var2, int var3, LocalMaterialData var4);

    public void attachMetadata(int var1, int var2, int var3, NamedBinaryTag var4);

    public NamedBinaryTag getMetadata(int var1, int var2, int var3);

    public int getLiquidHeight(int var1, int var2);

    public int getSolidHeight(int var1, int var2);

    public int getHighestBlockYAt(int var1, int var2);

    public int getLightLevel(int var1, int var2, int var3);

    public boolean isLoaded(int var1, int var2, int var3);

    @Deprecated
    public WorldSettings getSettings();

    public ConfigProvider getConfigs();

    public CustomObjectStructureCache getStructureCache();

    public String getName();

    public long getSeed();

    public int getHeightCap();

    public int getHeightScale();
}

