/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControlEngine;
import com.khorn.terraincontrol.configuration.ConfigFunctionsManager;
import com.khorn.terraincontrol.configuration.PluginConfig;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.CustomObjectManager;
import com.khorn.terraincontrol.events.EventHandler;
import com.khorn.terraincontrol.events.EventPriority;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.generator.biome.BiomeModeManager;
import com.khorn.terraincontrol.generator.resource.Resource;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.Marker;

public class TerrainControl {
    private static TerrainControlEngine engine;
    public static final int SUPPORTED_BLOCK_IDS = 4096;
    public static final int WORLD_DEPTH = 0;
    public static final int WORLD_HEIGHT = 256;

    public static boolean fireCanCustomObjectSpawnEvent(CustomObject object, LocalWorld world, int x, int y, int z) {
        return engine.fireCanCustomObjectSpawnEvent(object, world, x, y, z);
    }

    public static void firePopulationEndEvent(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        engine.firePopulationEndEvent(world, random, villageInChunk, chunkCoord);
    }

    public static void firePopulationStartEvent(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        engine.firePopulationStartEvent(world, random, villageInChunk, chunkCoord);
    }

    public static boolean fireResourceProcessEvent(Resource resource, LocalWorld world, Random random, boolean villageInChunk, int chunkX, int chunkZ) {
        return engine.fireResourceProcessEvent(resource, world, random, villageInChunk, chunkX, chunkZ);
    }

    public static BiomeModeManager getBiomeModeManager() {
        return engine.getBiomeModeManager();
    }

    public static String getBiomeName(String worldName, int x, int z) {
        LocalWorld world = TerrainControl.getWorld(worldName);
        if (world == null) {
            return null;
        }
        return world.getSavedBiome(x, z).getName();
    }

    public static ConfigFunctionsManager getConfigFunctionsManager() {
        return engine.getConfigFunctionsManager();
    }

    public static CustomObjectManager getCustomObjectManager() {
        return engine.getCustomObjectManager();
    }

    public static TerrainControlEngine getEngine() {
        return engine;
    }

    public static LocalMaterialData readMaterial(String name) throws InvalidConfigException {
        return engine.readMaterial(name);
    }

    public static LocalMaterialData toLocalMaterialData(DefaultMaterial defaultMaterial, int blockData) {
        return engine.toLocalMaterialData(defaultMaterial, blockData);
    }

    public static PluginConfig getPluginConfig() {
        return engine.getPluginConfig();
    }

    public static LocalWorld getWorld(String name) {
        return engine.getWorld(name);
    }

    public static void log(Marker level, List<String> messages) {
        engine.getLogger().log(level, messages);
    }

    public static void log(Marker level, String message, Object ... params) {
        engine.getLogger().log(level, message, params);
    }

    public static void logIfLevel(Marker ifLevel, List<String> messages) {
        engine.getLogger().logIfLevel(ifLevel, messages);
    }

    public static void logIfLevel(Marker ifLevel, String message, Object ... params) {
        engine.getLogger().logIfLevel(ifLevel, message, params);
    }

    public static void logIfLevel(Marker min, Marker max, List<String> messages) {
        engine.getLogger().logIfLevel(min, max, messages);
    }

    public static void logIfLevel(Marker min, Marker max, String message, Object ... params) {
        engine.getLogger().logIfLevel(min, max, message, params);
    }

    public static void printStackTrace(Marker level, Throwable e) {
        TerrainControl.printStackTrace(level, e, Integer.MAX_VALUE);
    }

    public static void printStackTrace(Marker level, Throwable e, int maxDepth) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        engine.getLogger().log(level, stringWriter.toString(), new Object[0]);
    }

    public static void registerEventHandler(EventHandler handler) {
        engine.registerEventHandler(handler);
    }

    public static void registerEventHandler(EventHandler handler, EventPriority priority) {
        engine.registerEventHandler(handler, priority);
    }

    public static void setEngine(TerrainControlEngine engine) {
        if (TerrainControl.engine != null) {
            throw new IllegalStateException("Engine is already set.");
        }
        TerrainControl.engine = engine;
        engine.onStart();
    }

    public static void stopEngine() {
        engine.onShutdown();
        engine = null;
    }

    private TerrainControl() {
    }
}

