/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.configuration.io.FileSettingsWriter;
import com.khorn.terraincontrol.configuration.io.SettingsReader;
import com.khorn.terraincontrol.configuration.io.SettingsWriter;
import com.khorn.terraincontrol.configuration.settingType.Setting;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultBiome;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class ConfigFile {
    public final SettingsReader reader;
    @Deprecated
    public final String name;
    @Deprecated
    public final File file;
    protected final boolean isNewConfig;

    protected ConfigFile(SettingsReader reader) throws IllegalArgumentException {
        this.reader = reader;
        this.isNewConfig = reader.isNewConfig();
        this.file = reader.getFile();
        this.name = reader.getName();
    }

    protected <T> T readSettings(Setting<T> setting) {
        return this.readSettings(setting, setting.getDefaultValue());
    }

    protected <T> T readSettings(Setting<T> setting, T defaultValue) {
        return this.reader.getSetting(setting, defaultValue);
    }

    public void write(SettingsWriter writer, WorldConfig.ConfigMode configMode) throws IOException {
        if (configMode == WorldConfig.ConfigMode.WriteDisable) {
            throw new IOException("ConfigMode is " + (Object)((Object)WorldConfig.ConfigMode.WriteDisable));
        }
        writer.setConfigMode(configMode);
        try {
            writer.open();
            this.writeConfigSettings(writer);
        }
        finally {
            writer.close();
        }
    }

    @Deprecated
    public void writeSettingsFile(boolean comments) {
        FileSettingsWriter.writeToFile(this, comments ? WorldConfig.ConfigMode.WriteAll : WorldConfig.ConfigMode.WriteWithoutComments);
    }

    public void logIOError(IOException e) {
        TerrainControl.log(LogMarker.ERROR, "Failed to write to file {}", this.file);
        TerrainControl.printStackTrace(LogMarker.ERROR, e);
    }

    protected abstract void writeConfigSettings(SettingsWriter var1) throws IOException;

    protected abstract void readConfigSettings();

    protected abstract void correctSettings();

    protected abstract void renameOldSettings();

    protected void renameOldSetting(String oldValue, Setting<?> newValue) {
        this.reader.renameOldSetting(oldValue, newValue);
    }

    protected int higherThan(int currentValue, int minimumValue) {
        if (currentValue <= minimumValue) {
            return minimumValue + 1;
        }
        return currentValue;
    }

    protected double higherThan(double currentValue, double minimumValue) {
        if (currentValue < minimumValue) {
            return minimumValue;
        }
        return currentValue;
    }

    protected int lowerThanOrEqualTo(int currentValue, int maximumValue) {
        if (currentValue > maximumValue) {
            return maximumValue;
        }
        return currentValue;
    }

    protected ArrayList<String> filterBiomes(List<String> biomes, Set<String> customBiomes) {
        ArrayList<String> output = new ArrayList<String>();
        for (String key : biomes) {
            if (customBiomes.contains(key = key.trim())) {
                output.add(key);
                continue;
            }
            if (!DefaultBiome.Contain(key)) continue;
            output.add(key);
        }
        return output;
    }

    protected static void writeStringToStream(DataOutputStream stream, String value) throws IOException {
        byte[] bytes = value.getBytes();
        stream.writeShort(bytes.length);
        stream.write(bytes);
    }

    public static String readStringFromStream(DataInputStream stream) throws IOException {
        byte[] chars = new byte[stream.readShort()];
        if (stream.read(chars, 0, chars.length) != chars.length) {
            throw new EOFException();
        }
        return new String(chars);
    }

    public String getName() {
        return this.reader.getName();
    }

    public File getFile() {
        return this.reader.getFile();
    }
}

