/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.MaterialSet;
import com.khorn.terraincontrol.util.helpers.StringHelper;
import java.util.ArrayList;
import java.util.List;

public abstract class ConfigFunction<T> {
    private String error;
    private T holder;
    private List<String> inputArgs;
    private String inputName;
    private boolean valid = true;

    public static final <T> ConfigFunction<T> create(T holder, Class<? extends ConfigFunction<T>> clazz, Object ... args) {
        ConfigFunction<T> configFunction;
        ArrayList<String> stringArgs = new ArrayList<String>(args.length);
        for (Object arg : args) {
            stringArgs.add("" + arg);
        }
        try {
            configFunction = clazz.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        configFunction.setHolder(holder);
        try {
            configFunction.load(stringArgs);
        }
        catch (InvalidConfigException e) {
            TerrainControl.log(LogMarker.FATAL, "Invalid default config function! Please report! {}: {}", clazz.getName(), e.getMessage());
            TerrainControl.printStackTrace(LogMarker.FATAL, e);
        }
        return configFunction;
    }

    protected final void assureSize(int size, List<String> args) throws InvalidConfigException {
        if (args.size() < size) {
            throw new InvalidConfigException("Too few arguments supplied");
        }
    }

    public final String getError() throws IllegalStateException {
        if (this.isValid()) {
            throw new IllegalStateException("Function is valid, so no error");
        }
        return this.error;
    }

    protected final T getHolder() {
        return this.holder;
    }

    public abstract Class<T> getHolderType();

    public final void init(T holder, List<String> args) throws InvalidConfigException {
        this.holder = holder;
        this.load(args);
    }

    public final void invalidate(String name, List<String> args, String error) {
        this.valid = false;
        this.inputName = name;
        this.inputArgs = args;
        this.error = error;
    }

    public abstract boolean isAnalogousTo(ConfigFunction<T> var1);

    public final boolean isValid() {
        return this.valid;
    }

    protected abstract void load(List<String> var1) throws InvalidConfigException;

    protected final String makeMaterials(MaterialSet materials) {
        return "," + materials.toString();
    }

    public abstract String makeString();

    protected final double readDouble(String string, double minValue, double maxValue) throws InvalidConfigException {
        return StringHelper.readDouble(string, minValue, maxValue);
    }

    protected final int readInt(String string, int minValue, int maxValue) throws InvalidConfigException {
        return StringHelper.readInt(string, minValue, maxValue);
    }

    protected final LocalMaterialData readMaterial(String string) throws InvalidConfigException {
        return TerrainControl.readMaterial(string);
    }

    protected final MaterialSet readMaterials(List<String> strings, int start) throws InvalidConfigException {
        MaterialSet materials = new MaterialSet();
        for (int i = start; i < strings.size(); ++i) {
            materials.parseAndAdd(strings.get(i));
        }
        return materials;
    }

    protected final double readRarity(String string) throws InvalidConfigException {
        return StringHelper.readDouble(string, 1.0E-6, 100.0);
    }

    public final void setHolder(T holder) {
        this.holder = holder;
    }

    @Deprecated
    public final void setValid(boolean valid) {
        if (!valid) {
            throw new UnsupportedOperationException("Use the invalidate method");
        }
        if (valid && !this.isValid()) {
            throw new UnsupportedOperationException("Revalidating objects is no longer supported");
        }
    }

    public final String write() {
        if (!this.valid) {
            return "## INVALID " + this.inputName.toUpperCase() + " - " + this.error + " ##" + System.getProperty("line.separator") + this.inputName + "(" + StringHelper.join(this.inputArgs, ",") + ")";
        }
        return this.makeString();
    }
}

