/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration;

import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.util.helpers.StringHelper;
import java.util.List;

final class ErroredFunction<T>
extends ConfigFunction<T> {
    private final Class<T> holder;
    private final String name;
    private final List<String> args;

    ErroredFunction(String name, T holder, List<String> args, String error) {
        Class<?> holderClass = holder.getClass();
        this.holder = holderClass;
        this.name = name;
        this.args = args;
        this.invalidate(name, args, error);
    }

    @Override
    public Class<T> getHolderType() {
        return this.holder;
    }

    @Override
    protected void load(List<String> args) throws InvalidConfigException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String makeString() {
        return this.name + "(" + StringHelper.join(this.args, ",") + ")";
    }

    @Override
    public boolean isAnalogousTo(ConfigFunction<T> other) {
        return this == other;
    }
}

