/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.util.helpers.StringHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ReplacedBlocksMatrix {
    private static final String NO_REPLACE = "None";
    public final int maxHeight;
    private List<ReplacedBlocksInstruction> instructions;
    public LocalMaterialData[][] compiledInstructions;

    public ReplacedBlocksMatrix(String setting, int maxHeight) throws InvalidConfigException {
        String[] keys;
        this.maxHeight = maxHeight;
        if (setting.isEmpty() || setting.equalsIgnoreCase(NO_REPLACE)) {
            this.setInstructions(Collections.<ReplacedBlocksInstruction>emptyList());
            return;
        }
        ArrayList<ReplacedBlocksInstruction> instructions = new ArrayList<ReplacedBlocksInstruction>();
        for (String key : keys = StringHelper.readCommaSeperatedString(setting)) {
            int start = key.indexOf(40);
            int end = key.lastIndexOf(41);
            if (start == -1 || end == -1) {
                throw new InvalidConfigException("One of the parts is missing braces around it.");
            }
            String keyWithoutBraces = key.substring(start + 1, end);
            instructions.add(new ReplacedBlocksInstruction(keyWithoutBraces, maxHeight));
        }
        this.setInstructions(instructions);
    }

    public boolean hasReplaceSettings() {
        return this.compiledInstructions != null;
    }

    public List<ReplacedBlocksInstruction> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(Collection<ReplacedBlocksInstruction> instructions) {
        this.instructions = Collections.unmodifiableList(new ArrayList<ReplacedBlocksInstruction>(instructions));
        if (this.instructions.size() == 0) {
            this.compiledInstructions = null;
            return;
        }
        this.compiledInstructions = new LocalMaterialData[4096][];
        for (ReplacedBlocksInstruction instruction : instructions) {
            int fromBlockId = instruction.getFrom().getBlockId();
            int minHeight = instruction.getMinHeight();
            int maxHeight = instruction.getMaxHeight();
            LocalMaterialData toBlock = instruction.getTo();
            if (this.compiledInstructions[fromBlockId] == null) {
                this.compiledInstructions[fromBlockId] = new LocalMaterialData[this.maxHeight + 1];
            }
            for (int y = minHeight; y <= maxHeight; ++y) {
                this.compiledInstructions[fromBlockId][y] = toBlock;
            }
        }
    }

    public String toString() {
        if (!this.hasReplaceSettings()) {
            return NO_REPLACE;
        }
        StringBuilder builder = new StringBuilder();
        for (ReplacedBlocksInstruction instruction : this.getInstructions()) {
            builder.append('(');
            builder.append(instruction.getFrom());
            builder.append(',').append(instruction.getTo());
            if (instruction.getMinHeight() != 0 || instruction.getMaxHeight() != this.maxHeight) {
                builder.append(',').append(instruction.getMinHeight());
                builder.append(',').append(instruction.getMaxHeight());
            }
            builder.append(')').append(',');
        }
        return builder.substring(0, builder.length() - 1);
    }

    public static ReplacedBlocksMatrix createEmptyMatrix(int maxHeight) {
        try {
            return new ReplacedBlocksMatrix(NO_REPLACE, maxHeight);
        }
        catch (InvalidConfigException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static class ReplacedBlocksInstruction {
        private final LocalMaterialData from;
        private final LocalMaterialData to;
        private final int minHeight;
        private final int maxHeight;

        public ReplacedBlocksInstruction(String instruction, int maxAllowedY) throws InvalidConfigException {
            String[] values = instruction.split(",");
            if (values.length == 5) {
                values = new String[]{values[0], values[1] + ":" + values[2], values[3], "" + (Integer.parseInt(values[4]) - 1)};
            }
            if (values.length != 2 && values.length != 4) {
                throw new InvalidConfigException("Replace parts must be in the format (from,to) or (from,to,minHeight,maxHeight)");
            }
            this.from = TerrainControl.readMaterial(values[0]).withBlockData(0);
            this.to = TerrainControl.readMaterial(values[1]);
            if (values.length == 4) {
                this.minHeight = StringHelper.readInt(values[2], 0, maxAllowedY);
                this.maxHeight = StringHelper.readInt(values[3], this.minHeight, maxAllowedY);
            } else {
                this.minHeight = 0;
                this.maxHeight = maxAllowedY;
            }
        }

        public ReplacedBlocksInstruction(LocalMaterialData from, LocalMaterialData to, int minHeight, int maxHeight) {
            this.from = from;
            this.to = to;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        }

        public LocalMaterialData getFrom() {
            return this.from;
        }

        public LocalMaterialData getTo() {
            return this.to;
        }

        public int getMinHeight() {
            return this.minHeight;
        }

        public int getMaxHeight() {
            return this.maxHeight;
        }
    }
}

