/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.ConfigFile;
import com.khorn.terraincontrol.configuration.io.SettingsReader;
import com.khorn.terraincontrol.configuration.io.SettingsWriter;
import com.khorn.terraincontrol.configuration.standard.BiomeStandardValues;
import com.khorn.terraincontrol.configuration.standard.WorldStandardValues;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.CustomObjectCollection;
import com.khorn.terraincontrol.generator.biome.BiomeGenerator;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultBiome;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WorldConfig
extends ConfigFile {
    public final File settingsDir;
    private final Comparator<Map.Entry<String, Integer>> CBV = new Comparator<Map.Entry<String, Integer>>(){

        @Override
        public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
            return o1.getValue() - o2.getValue();
        }
    };
    public Map<String, Integer> customBiomeGenerationIds = new HashMap<String, Integer>();
    public final CustomObjectCollection worldObjects;
    @Deprecated
    public final List<CustomObject> customObjects;
    public List<String> NormalBiomes = new ArrayList<String>();
    public List<String> IceBiomes = new ArrayList<String>();
    public List<String> IsleBiomes = new ArrayList<String>();
    public List<String> BorderBiomes = new ArrayList<String>();
    public int maxSmoothRadius = 2;
    public double oldBiomeSize;
    public double minMoisture;
    public double maxMoisture;
    public double minTemperature;
    public double maxTemperature;
    public int GenerationDepth;
    public int BiomeRarityScale;
    public int LandRarity;
    public int LandSize;
    public int LandFuzzy;
    public int IceRarity;
    public int IceSize;
    public boolean FrozenOcean;
    public int riverRarity;
    public int riverSize;
    public boolean riversEnabled;
    public boolean improvedRivers;
    public boolean randomRivers;
    public String imageFile;
    public ImageOrientation imageOrientation;
    public ImageMode imageMode;
    public String imageFillBiome;
    public int imageXOffset;
    public int imageZOffset;
    public HashMap<Integer, Integer> biomeColorMap;
    public int WorldFog;
    public float WorldFogR;
    public float WorldFogG;
    public float WorldFogB;
    public int WorldNightFog;
    public float WorldNightFogR;
    public float WorldNightFogG;
    public float WorldNightFogB;
    public int caveRarity;
    public int caveFrequency;
    public int caveMinAltitude;
    public int caveMaxAltitude;
    public int individualCaveRarity;
    public int caveSystemFrequency;
    public int caveSystemPocketChance;
    public int caveSystemPocketMinSize;
    public int caveSystemPocketMaxSize;
    public boolean evenCaveDistribution;
    public int canyonRarity;
    public int canyonMinAltitude;
    public int canyonMaxAltitude;
    public int canyonMinLength;
    public int canyonMaxLength;
    public double canyonDepth;
    public boolean strongholdsEnabled;
    public double strongholdDistance;
    public int strongholdCount;
    public int strongholdSpread;
    public boolean villagesEnabled;
    public int villageSize;
    public int villageDistance;
    public boolean rareBuildingsEnabled;
    public int minimumDistanceBetweenRareBuildings;
    public int maximumDistanceBetweenRareBuildings;
    public boolean mineshaftsEnabled;
    public boolean netherFortressesEnabled;
    public boolean oldTerrainGenerator;
    public int waterLevelMax;
    public int waterLevelMin;
    public LocalMaterialData waterBlock;
    public LocalMaterialData iceBlock;
    public double fractureHorizontal;
    public double fractureVertical;
    public boolean disableBedrock;
    public boolean flatBedrock;
    public boolean ceilingBedrock;
    public LocalMaterialData bedrockBlock;
    public boolean populationBoundsCheck;
    public boolean populateUsingSavedBiomes;
    public boolean removeSurfaceStone;
    public int objectSpawnRatio;
    public File customObjectsDirectory;
    public ConfigMode SettingsMode;
    public TerrainMode ModeTerrain;
    public Class<? extends BiomeGenerator> biomeMode;
    public boolean BiomeConfigsHaveReplacement = false;
    public int normalBiomesRarity;
    public int iceBiomesRarity;
    public int worldHeightScaleBits;
    public int worldHeightScale;
    public int worldHeightCapBits;
    public int worldHeightCap;
    public long resourcesSeed;

    public WorldConfig(SettingsReader settingsReader, LocalWorld world, CustomObjectCollection customObjects) {
        super(settingsReader);
        this.settingsDir = settingsReader.getFile() != null ? settingsReader.getFile().getParentFile() : new File(".");
        this.worldObjects = customObjects;
        this.customObjects = customObjects.getAll();
        this.readConfigSettings();
        this.renameOldSettings();
        this.readConfigSettings();
        this.correctSettings();
        this.ReadWorldCustomObjects();
        Iterator<Map.Entry<String, Integer>> it = this.customBiomeGenerationIds.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Integer> entry = it.next();
            String biomeName = entry.getKey();
            if (DefaultBiome.Contain(biomeName)) {
                TerrainControl.log(LogMarker.WARN, "CustomBiomes only accepts custom biomes, {} is a vanilla biome. Removing it from the list.", biomeName);
                it.remove();
                continue;
            }
            int biomeId = entry.getValue();
            if (biomeId != -1) continue;
            entry.setValue(world.getFreeBiomeId());
        }
    }

    private void ReadWorldCustomObjects() {
        this.customObjectsDirectory = new File(this.settingsDir, "WorldObjects");
        File oldCustomObjectsDirectory = new File(this.settingsDir, "BOBPlugins");
        if (oldCustomObjectsDirectory.exists() && !oldCustomObjectsDirectory.renameTo(new File(this.settingsDir, "WorldObjects"))) {
            TerrainControl.log(LogMarker.WARN, "Fould old BOBPlugins folder, but it cannot be renamed to WorldObjects.", new Object[0]);
            TerrainControl.log(LogMarker.WARN, "Please move the BO2s manually and delete BOBPlugins afterwards.", new Object[0]);
        }
        if (!this.customObjectsDirectory.exists() && !this.customObjectsDirectory.mkdirs()) {
            TerrainControl.log(LogMarker.WARN, "Can`t create WorldObjects folder. No write permissions?", new Object[0]);
            return;
        }
    }

    @Override
    protected void renameOldSettings() {
        this.renameOldSetting("WaterLevel", WorldStandardValues.WATER_LEVEL_MAX);
        this.renameOldSetting("ModeTerrain", WorldStandardValues.TERRAIN_MODE);
        this.renameOldSetting("ModeBiome", WorldStandardValues.BIOME_MODE);
        this.renameOldSetting("NetherFortressEnabled", WorldStandardValues.NETHER_FORTRESSES_ENABLED);
        this.renameOldSetting("PyramidsEnabled", WorldStandardValues.RARE_BUILDINGS_ENABLED);
        this.renameOldSetting("WorldHeightBits", WorldStandardValues.WORLD_HEIGHT_SCALE_BITS);
        this.renameOldSetting("WorldHeightBits", WorldStandardValues.WORLD_HEIGHT_CAP_BITS);
    }

    @Override
    protected void correctSettings() {
        File mapFile;
        this.LandSize = this.lowerThanOrEqualTo(this.LandSize, this.GenerationDepth);
        this.LandFuzzy = this.lowerThanOrEqualTo(this.LandFuzzy, this.GenerationDepth - this.LandSize);
        this.IceSize = this.lowerThanOrEqualTo(this.IceSize, this.GenerationDepth);
        this.riverRarity = this.lowerThanOrEqualTo(this.riverRarity, this.GenerationDepth);
        this.riverSize = this.lowerThanOrEqualTo(this.riverSize, this.GenerationDepth - this.riverRarity);
        this.NormalBiomes = this.filterBiomes(this.NormalBiomes, this.customBiomeGenerationIds.keySet());
        this.IceBiomes = this.filterBiomes(this.IceBiomes, this.customBiomeGenerationIds.keySet());
        this.IsleBiomes = this.filterBiomes(this.IsleBiomes, this.customBiomeGenerationIds.keySet());
        this.BorderBiomes = this.filterBiomes(this.BorderBiomes, this.customBiomeGenerationIds.keySet());
        if (this.biomeMode == TerrainControl.getBiomeModeManager().FROM_IMAGE && !(mapFile = new File(this.settingsDir, this.imageFile)).exists()) {
            TerrainControl.log(LogMarker.WARN, "Biome map file not found. Switching BiomeMode to Normal", new Object[0]);
            this.biomeMode = TerrainControl.getBiomeModeManager().NORMAL;
        }
        this.imageFillBiome = DefaultBiome.Contain(this.imageFillBiome) || this.customBiomeGenerationIds.keySet().contains(this.imageFillBiome) ? this.imageFillBiome : WorldStandardValues.IMAGE_FILL_BIOME.getDefaultValue();
        this.maxMoisture = this.higherThan(this.maxMoisture, this.minMoisture);
        this.maxTemperature = this.higherThan(this.maxTemperature, this.minTemperature);
        this.caveMaxAltitude = this.higherThan(this.caveMaxAltitude, this.caveMinAltitude);
        this.caveSystemPocketMaxSize = this.higherThan(this.caveSystemPocketMaxSize, this.caveSystemPocketMinSize);
        this.canyonMaxAltitude = this.higherThan(this.canyonMaxAltitude, this.canyonMinAltitude);
        this.canyonMaxLength = this.higherThan(this.canyonMaxLength, this.canyonMinLength);
        this.waterLevelMax = this.higherThan(this.waterLevelMax, this.waterLevelMin);
        this.waterBlock = this.waterBlock.withBlockData(0);
        this.iceBlock = this.iceBlock.withBlockData(0);
        this.bedrockBlock = this.bedrockBlock.withBlockData(0);
        this.maximumDistanceBetweenRareBuildings = this.higherThan(this.maximumDistanceBetweenRareBuildings, this.minimumDistanceBetweenRareBuildings);
        if (this.biomeMode == TerrainControl.getBiomeModeManager().OLD_GENERATOR && this.ModeTerrain != TerrainMode.OldGenerator) {
            TerrainControl.log(LogMarker.WARN, "Old biome generator works only with old terrain generator!", new Object[0]);
            this.biomeMode = TerrainControl.getBiomeModeManager().NORMAL;
        }
    }

    @Override
    protected void readConfigSettings() {
        this.SettingsMode = this.readSettings(WorldStandardValues.SETTINGS_MODE);
        this.ModeTerrain = this.readSettings(WorldStandardValues.TERRAIN_MODE);
        this.biomeMode = TerrainControl.getBiomeModeManager().getBiomeManager(this.readSettings(WorldStandardValues.BIOME_MODE));
        this.worldHeightCapBits = this.readSettings(WorldStandardValues.WORLD_HEIGHT_CAP_BITS);
        this.worldHeightCap = 1 << this.worldHeightCapBits;
        this.worldHeightScaleBits = this.readSettings(WorldStandardValues.WORLD_HEIGHT_SCALE_BITS);
        this.worldHeightScaleBits = this.lowerThanOrEqualTo(this.worldHeightScaleBits, this.worldHeightCapBits);
        this.worldHeightScale = 1 << this.worldHeightScaleBits;
        this.waterLevelMax = this.worldHeightCap / 2 - 1;
        this.GenerationDepth = this.readSettings(WorldStandardValues.GENERATION_DEPTH);
        this.BiomeRarityScale = this.readSettings(WorldStandardValues.BIOME_RARITY_SCALE);
        this.LandRarity = this.readSettings(WorldStandardValues.LAND_RARITY);
        this.LandSize = this.readSettings(WorldStandardValues.LAND_SIZE);
        this.LandFuzzy = this.readSettings(WorldStandardValues.LAND_FUZZY);
        this.IceRarity = this.readSettings(WorldStandardValues.ICE_RARITY);
        this.IceSize = this.readSettings(WorldStandardValues.ICE_SIZE);
        this.FrozenOcean = this.readSettings(WorldStandardValues.FROZEN_OCEAN);
        this.riverRarity = this.readSettings(WorldStandardValues.RIVER_RARITY);
        this.riverSize = this.readSettings(WorldStandardValues.RIVER_SIZE);
        this.riversEnabled = this.readSettings(WorldStandardValues.RIVERS_ENABLED);
        this.improvedRivers = this.readSettings(WorldStandardValues.IMPROVED_RIVERS);
        this.randomRivers = this.readSettings(WorldStandardValues.RANDOM_RIVERS);
        this.NormalBiomes = this.readSettings(WorldStandardValues.NORMAL_BIOMES);
        this.IceBiomes = this.readSettings(WorldStandardValues.ICE_BIOMES);
        this.IsleBiomes = this.readSettings(WorldStandardValues.ISLE_BIOMES);
        this.BorderBiomes = this.readSettings(WorldStandardValues.BORDER_BIOMES);
        this.ReadCustomBiomes();
        this.imageMode = this.readSettings(WorldStandardValues.IMAGE_MODE);
        this.imageFile = this.readSettings(WorldStandardValues.IMAGE_FILE);
        this.imageOrientation = this.readSettings(WorldStandardValues.IMAGE_ORIENTATION);
        this.imageFillBiome = this.readSettings(WorldStandardValues.IMAGE_FILL_BIOME);
        this.imageXOffset = this.readSettings(WorldStandardValues.IMAGE_X_OFFSET);
        this.imageZOffset = this.readSettings(WorldStandardValues.IMAGE_Z_OFFSET);
        this.oldBiomeSize = this.readSettings(WorldStandardValues.OLD_BIOME_SIZE);
        this.minMoisture = this.readSettings(WorldStandardValues.MIN_MOISTURE);
        this.maxMoisture = this.readSettings(WorldStandardValues.MAX_MOISTURE);
        this.minTemperature = this.readSettings(WorldStandardValues.MIN_TEMPERATURE);
        this.maxTemperature = this.readSettings(WorldStandardValues.MAX_TEMPERATURE);
        this.WorldFog = this.readSettings(WorldStandardValues.WORLD_FOG);
        this.WorldNightFog = this.readSettings(WorldStandardValues.WORLD_NIGHT_FOG);
        this.WorldFogR = (float)((this.WorldFog & 0xFF0000) >> 16) / 255.0f;
        this.WorldFogG = (float)((this.WorldFog & 0xFF00) >> 8) / 255.0f;
        this.WorldFogB = (float)(this.WorldFog & 0xFF) / 255.0f;
        this.WorldNightFogR = (float)((this.WorldNightFog & 0xFF0000) >> 16) / 255.0f;
        this.WorldNightFogG = (float)((this.WorldNightFog & 0xFF00) >> 8) / 255.0f;
        this.WorldNightFogB = (float)(this.WorldNightFog & 0xFF) / 255.0f;
        this.strongholdsEnabled = this.readSettings(WorldStandardValues.STRONGHOLDS_ENABLED);
        this.strongholdCount = this.readSettings(WorldStandardValues.STRONGHOLD_COUNT);
        this.strongholdDistance = this.readSettings(WorldStandardValues.STRONGHOLD_DISTANCE);
        this.strongholdSpread = this.readSettings(WorldStandardValues.STRONGHOLD_SPREAD);
        this.villagesEnabled = this.readSettings(WorldStandardValues.VILLAGES_ENABLED);
        this.villageDistance = this.readSettings(WorldStandardValues.VILLAGE_DISTANCE);
        this.villageSize = this.readSettings(WorldStandardValues.VILLAGE_SIZE);
        this.rareBuildingsEnabled = this.readSettings(WorldStandardValues.RARE_BUILDINGS_ENABLED);
        this.minimumDistanceBetweenRareBuildings = this.readSettings(WorldStandardValues.MINIMUM_DISTANCE_BETWEEN_RARE_BUILDINGS);
        this.maximumDistanceBetweenRareBuildings = this.readSettings(WorldStandardValues.MAXIMUM_DISTANCE_BETWEEN_RARE_BUILDINGS);
        this.mineshaftsEnabled = this.readSettings(WorldStandardValues.MINESHAFTS_ENABLED);
        this.netherFortressesEnabled = this.readSettings(WorldStandardValues.NETHER_FORTRESSES_ENABLED);
        this.caveRarity = this.readSettings(WorldStandardValues.CAVE_RARITY);
        this.caveFrequency = this.readSettings(WorldStandardValues.CAVE_FREQUENCY);
        this.caveMinAltitude = this.readSettings(WorldStandardValues.CAVE_MIN_ALTITUDE);
        this.caveMaxAltitude = this.readSettings(WorldStandardValues.CAVE_MAX_ALTITUDE);
        this.individualCaveRarity = this.readSettings(WorldStandardValues.INDIVIDUAL_CAVE_RARITY);
        this.caveSystemFrequency = this.readSettings(WorldStandardValues.CAVE_SYSTEM_FREQUENCY);
        this.caveSystemPocketChance = this.readSettings(WorldStandardValues.CAVE_SYSTEM_POCKET_CHANCE);
        this.caveSystemPocketMinSize = this.readSettings(WorldStandardValues.CAVE_SYSTEM_POCKET_MIN_SIZE);
        this.caveSystemPocketMaxSize = this.readSettings(WorldStandardValues.CAVE_SYSTEM_POCKET_MAX_SIZE);
        this.evenCaveDistribution = this.readSettings(WorldStandardValues.EVEN_CAVE_DISTRIBUTION);
        this.canyonRarity = this.readSettings(WorldStandardValues.CANYON_RARITY);
        this.canyonMinAltitude = this.readSettings(WorldStandardValues.CANYON_MIN_ALTITUDE);
        this.canyonMaxAltitude = this.readSettings(WorldStandardValues.CANYON_MAX_ALTITUDE);
        this.canyonMinLength = this.readSettings(WorldStandardValues.CANYON_MIN_LENGTH);
        this.canyonMaxLength = this.readSettings(WorldStandardValues.CANYON_MAX_LENGTH);
        this.canyonDepth = this.readSettings(WorldStandardValues.CANYON_DEPTH);
        this.waterLevelMax = this.readSettings(WorldStandardValues.WATER_LEVEL_MAX);
        this.waterLevelMin = this.readSettings(WorldStandardValues.WATER_LEVEL_MIN);
        this.waterBlock = this.readSettings(WorldStandardValues.WATER_BLOCK);
        this.iceBlock = this.readSettings(WorldStandardValues.ICE_BLOCK);
        this.fractureHorizontal = this.readSettings(WorldStandardValues.FRACTURE_HORIZONTAL);
        this.fractureVertical = this.readSettings(WorldStandardValues.FRACTURE_VERTICAL);
        this.disableBedrock = this.readSettings(WorldStandardValues.DISABLE_BEDROCK);
        this.ceilingBedrock = this.readSettings(WorldStandardValues.CEILING_BEDROCK);
        this.flatBedrock = this.readSettings(WorldStandardValues.FLAT_BEDROCK);
        this.bedrockBlock = this.readSettings(WorldStandardValues.BEDROCK_BLOCK);
        this.removeSurfaceStone = this.readSettings(WorldStandardValues.REMOVE_SURFACE_STONE);
        this.objectSpawnRatio = this.readSettings(WorldStandardValues.OBJECT_SPAWN_RATIO);
        this.resourcesSeed = this.readSettings(WorldStandardValues.RESOURCES_SEED);
        this.populationBoundsCheck = this.readSettings(WorldStandardValues.POPULATION_BOUNDS_CHECK);
        this.populateUsingSavedBiomes = this.readSettings(WorldStandardValues.POPULATE_USING_SAVED_BIOMES);
        this.oldTerrainGenerator = this.ModeTerrain == TerrainMode.OldGenerator;
    }

    private void ReadCustomBiomes() {
        List<String> biomes = this.readSettings(WorldStandardValues.CUSTOM_BIOMES);
        for (String biome : biomes) {
            try {
                String[] keys = biome.split(":");
                if (keys[0].isEmpty()) continue;
                if (keys.length == 2) {
                    int generationBiomeId = Integer.parseInt(keys[1]);
                    this.customBiomeGenerationIds.put(keys[0], generationBiomeId);
                    continue;
                }
                this.customBiomeGenerationIds.put(keys[0], -1);
            }
            catch (NumberFormatException e) {
                System.out.println("Wrong custom biome id settings: '" + biome + "'");
            }
        }
    }

    @Override
    protected void writeConfigSettings(SettingsWriter writer) throws IOException {
        writer.bigTitle("The modes");
        writer.comment("What Terrain Control does with the config files.");
        writer.comment("Possible modes:");
        writer.comment("   WriteAll - default");
        writer.comment("   WriteWithoutComments - write config files without help comments");
        writer.comment("   WriteDisable - doesn't write to the config files, it only reads. Doesn't auto-update the configs. Use with care!");
        writer.setting(WorldStandardValues.SETTINGS_MODE, this.SettingsMode);
        writer.comment("Possible terrain modes:");
        writer.comment("   Normal - use all features");
        writer.comment("   OldGenerator - generate land like Beta 1.7.3 generator");
        writer.comment("   TerrainTest - generate only terrain without any resources");
        writer.comment("   NotGenerate - generate empty chunks");
        writer.comment("   Default - use default terrain generator");
        writer.setting(WorldStandardValues.TERRAIN_MODE, this.ModeTerrain);
        writer.comment("Possible biome modes:");
        writer.comment("   Normal - use all features");
        writer.comment("   FromImage - get biomes from image file");
        writer.comment("   OldGenerator - generate biome like the Beta 1.7.3 generator");
        writer.comment("   Default - use default Notch biome generator");
        writer.setting(WorldStandardValues.BIOME_MODE, TerrainControl.getBiomeModeManager().getName(this.biomeMode));
        writer.bigTitle("Custom biomes");
        writer.comment("You need to register your custom biomes here. This setting will make Terrain Control");
        writer.comment("generate setting files for them. However, it won't place them in the world automatically.");
        writer.comment("See the settings for your BiomeMode below on how to add them to the world.");
        writer.comment("");
        writer.comment("Syntax: CustomBiomes:BiomeName:id[,AnotherBiomeName:id[,...]]");
        writer.comment("Example: CustomBiomes:TestBiome1:30,BiomeTest2:31");
        writer.comment("This will add two biomes and generate the BiomeConfigs for them.");
        writer.comment("All changes here need a server restart.");
        writer.comment("");
        writer.comment("Due to the way Mojang's loading code works, all biome ids need to be unique");
        writer.comment("on the server. If you don't do this, the client will display the biomes just fine,");
        writer.comment("but the server can think it is another biome with the same id. This will cause saplings,");
        writer.comment("snowfall and mobs to work as in the other biome.");
        writer.comment("");
        writer.comment("The available ids range from 0 to 1023 and the ids 0-39 and 129-167 are taken by vanilla.");
        writer.comment("The ids 256-1023 cannot be saved to the map files, so use ReplaceToBiomeName in that biome.");
        this.WriteCustomBiomes(writer);
        writer.bigTitle("Settings for BiomeMode:Normal");
        writer.comment("Also applies if you are using BiomeMode:FromImage and ImageMode:ContinueNormal.");
        writer.comment("Important value for generation. Bigger values appear to zoom out. All 'Sizes' must be smaller than this.");
        writer.comment("Large %/total area biomes (Continents) must be set small, (limit=0)");
        writer.comment("Small %/total area biomes (Oasis,Mountain Peaks) must be larger (limit=GenerationDepth)");
        writer.comment("This could also represent \"Total number of biome sizes\" ");
        writer.comment("Small values (about 1-2) and Large values (about 20) may affect generator performance.");
        writer.setting(WorldStandardValues.GENERATION_DEPTH, this.GenerationDepth);
        writer.comment("Max biome rarity from 1 to infinity. By default this is 100, but you can raise it for");
        writer.comment("fine-grained control, or to create biomes with a chance of occurring smaller than 1/100.");
        writer.setting(WorldStandardValues.BIOME_RARITY_SCALE, this.BiomeRarityScale);
        writer.smallTitle("Biome lists");
        writer.comment("Don't forget to register your custom biomes first in CustomBiomes!");
        writer.comment("Biomes generated normal way. Names are case sensitive.");
        writer.setting(WorldStandardValues.NORMAL_BIOMES, this.NormalBiomes);
        writer.comment("Biomes generated in \"ice areas\". Names are case sensitive.");
        writer.setting(WorldStandardValues.ICE_BIOMES, this.IceBiomes);
        writer.comment("Biomes used as isles in other biomes. You must set IsleInBiome in biome config for each biome here. Biome name is case sensitive.");
        writer.setting(WorldStandardValues.ISLE_BIOMES, this.IsleBiomes);
        writer.comment("Biomes used as borders of other biomes. You must set BiomeIsBorder in biome config for each biome here. Biome name is case sensitive.");
        writer.setting(WorldStandardValues.BORDER_BIOMES, this.BorderBiomes);
        writer.smallTitle("Landmass settings (for NormalBiomes)");
        writer.comment("Land rarity from 100 to 1. If you set smaller than 90 and LandSize near 0 beware Big oceans.");
        writer.setting(WorldStandardValues.LAND_RARITY, this.LandRarity);
        writer.comment("Land size from 0 to GenerationDepth.");
        writer.setting(WorldStandardValues.LAND_SIZE, this.LandSize);
        writer.comment("Make land more fuzzy and make lakes. Must be from 0 to GenerationDepth - LandSize");
        writer.setting(WorldStandardValues.LAND_FUZZY, this.LandFuzzy);
        writer.smallTitle("Ice area settings (for IceBiomes)");
        writer.comment("Rarity of the \"ice areas\" from 100 to 1. 100 = ice world, 1 = no IceBiomes");
        writer.setting(WorldStandardValues.ICE_RARITY, this.IceRarity);
        writer.comment("Ice area size from 0 to GenerationDepth.");
        writer.setting(WorldStandardValues.ICE_SIZE, this.IceSize);
        writer.comment("Set this to false to stop the ocean from freezing near when an \"ice area\" intersects with an ocean.");
        writer.setting(WorldStandardValues.FROZEN_OCEAN, this.FrozenOcean);
        writer.smallTitle("Rivers");
        writer.comment("River rarity. Must be from 0 to GenerationDepth.");
        writer.setting(WorldStandardValues.RIVER_RARITY, this.riverRarity);
        writer.comment("River size from 0 to GenerationDepth - RiverRarity");
        writer.setting(WorldStandardValues.RIVER_SIZE, this.riverSize);
        writer.comment("Set this to false to prevent the river generator from doing anything.");
        writer.setting(WorldStandardValues.RIVERS_ENABLED, this.riversEnabled);
        writer.comment("When this is set to false, the standard river generator of Minecraft will be used.");
        writer.comment("This means that a technical biome, determined by the RiverBiome setting of the biome");
        writer.comment("the river is flowing through, will be used to generate the river.");
        writer.comment("");
        writer.comment("When enabled, the rivers won't use a technical biome in your world anymore, instead");
        writer.comment("you can control them using the river settings in the BiomeConfigs.");
        writer.setting(WorldStandardValues.IMPROVED_RIVERS, this.improvedRivers);
        writer.comment("When set to true the rivers will no longer follow biome border most of the time.");
        writer.setting(WorldStandardValues.RANDOM_RIVERS, this.randomRivers);
        writer.bigTitle("Settings for BiomeMode:FromImage");
        writer.comment("Possible modes when generator outside image boundaries: Repeat, ContinueNormal, FillEmpty");
        writer.comment("   Repeat - repeat image");
        writer.comment("   Mirror - advanced repeat image mode");
        writer.comment("   ContinueNormal - continue normal generation");
        writer.comment("   FillEmpty - fill by biome in \"ImageFillBiome settings\" ");
        writer.setting(WorldStandardValues.IMAGE_MODE, this.imageMode);
        writer.comment("Source png file for FromImage biome mode.");
        writer.setting(WorldStandardValues.IMAGE_FILE, this.imageFile);
        writer.comment("Where the png's north is oriented? Possible values: North, East, South, West");
        writer.comment("   North - the top of your picture if north (no any rotation)");
        writer.comment("   West - previous behavior (you should rotate png CCW manually)");
        writer.comment("   East - png should be rotated CW manually");
        writer.comment("   South - rotate png 180 degrees before generating world");
        writer.setting(WorldStandardValues.IMAGE_ORIENTATION, this.imageOrientation);
        writer.comment("Biome name for fill outside image boundaries with FillEmpty mode.");
        writer.setting(WorldStandardValues.IMAGE_FILL_BIOME, this.imageFillBiome);
        writer.comment("Shifts map position from x=0 and z=0 coordinates.");
        writer.setting(WorldStandardValues.IMAGE_X_OFFSET, this.imageXOffset);
        writer.setting(WorldStandardValues.IMAGE_Z_OFFSET, this.imageZOffset);
        writer.bigTitle("Terrain height and volatility");
        writer.comment("Scales the height of the world. Adding 1 to this doubles the");
        writer.comment("height of the terrain, substracting 1 to this halves the height");
        writer.comment("of the terrain. Values must be between 5 and 8, inclusive.");
        writer.setting(WorldStandardValues.WORLD_HEIGHT_SCALE_BITS, this.worldHeightScaleBits);
        writer.comment("Height cap of the base terrain. Setting this to 7 makes no terrain");
        writer.comment("generate above y = 2 ^ 7 = 128. Doesn't affect resources (trees, objects, etc.).");
        writer.comment("Values must be between 5 and 8, inclusive. Values may not be lower");
        writer.comment("than WorldHeightScaleBits.");
        writer.setting(WorldStandardValues.WORLD_HEIGHT_CAP_BITS, this.worldHeightCapBits);
        writer.comment("Can increase (values greater than 0) or decrease (values less than 0) how much the landscape is fractured horizontally.");
        writer.setting(WorldStandardValues.FRACTURE_HORIZONTAL, this.fractureHorizontal);
        writer.comment("Can increase (values greater than 0) or decrease (values less than 0) how much the landscape is fractured vertically.");
        writer.comment("Positive values will lead to large cliffs/overhangs, floating islands, and/or a cavern world depending on other settings.");
        writer.setting(WorldStandardValues.FRACTURE_VERTICAL, this.fractureVertical);
        writer.bigTitle("Blocks");
        writer.comment("Attempts to replace all surface stone with biome surface block");
        writer.setting(WorldStandardValues.REMOVE_SURFACE_STONE, this.removeSurfaceStone);
        writer.comment("Disable bottom of map bedrock generation");
        writer.setting(WorldStandardValues.DISABLE_BEDROCK, this.disableBedrock);
        writer.comment("Enable ceiling of map bedrock generation");
        writer.setting(WorldStandardValues.CEILING_BEDROCK, this.ceilingBedrock);
        writer.comment("Make bottom layer of bedrock flat");
        writer.setting(WorldStandardValues.FLAT_BEDROCK, this.flatBedrock);
        writer.comment("Block used as bedrock. No block data allowed.");
        writer.setting(WorldStandardValues.BEDROCK_BLOCK, this.bedrockBlock);
        writer.comment("Set this to false to disable the bounds check during chunk population.");
        writer.comment("While this allows you to spawn larger objects, it also makes terrain generation");
        writer.comment("dependant on the direction you explored the world in.");
        writer.setting(WorldStandardValues.POPULATION_BOUNDS_CHECK, this.populationBoundsCheck);
        if (this.populateUsingSavedBiomes) {
            writer.comment("Advanced setting, only written to this file when set to true.");
            writer.comment("If it is set to true the biome populator will use the biome ids present in the");
            writer.comment("chunk data, ignoring the biome generator. This is useful if you have a premade");
            writer.comment("map made with for example WorldPainter, but still want to populate it using Terrain Control.");
            writer.comment("Using this together with " + BiomeStandardValues.REPLACE_TO_BIOME_NAME + " is discouraged: it uses the biome");
            writer.comment("specified in " + BiomeStandardValues.REPLACE_TO_BIOME_NAME + " to populate the chunk, instead of the biome itself.");
            writer.setting(WorldStandardValues.POPULATE_USING_SAVED_BIOMES, this.populateUsingSavedBiomes);
        }
        writer.smallTitle("Water and ice");
        writer.comment("Set water level. Every empty block under this level will be fill water or another block from WaterBlock ");
        writer.setting(WorldStandardValues.WATER_LEVEL_MAX, this.waterLevelMax);
        writer.setting(WorldStandardValues.WATER_LEVEL_MIN, this.waterLevelMin);
        writer.comment("Block used as water in WaterLevel. No block data allowed.");
        writer.setting(WorldStandardValues.WATER_BLOCK, this.waterBlock);
        writer.comment("BlockId used as ice. No block data allowed.");
        writer.setting(WorldStandardValues.ICE_BLOCK, this.iceBlock);
        writer.comment("Seed used for the resource generation. Can only be numeric. Set to 0 to use the world seed.");
        writer.setting(WorldStandardValues.RESOURCES_SEED, this.resourcesSeed);
        if (this.objectSpawnRatio != 1) {
            writer.comment("LEGACY setting for compability with old worlds. This setting should be kept at 1.");
            writer.comment("If the setting is set at 1, the setting will vanish from the config file. Readd it");
            writer.comment("manually with another value and it will be back.");
            writer.comment("");
            writer.comment("When using the UseWorld or UseBiome keyword for spawning custom objects, Terrain Control");
            writer.comment("spawns one of the possible custom objects. There is of course a chance that");
            writer.comment("the chosen object cannot spawn. This setting tells TC how many times it should");
            writer.comment("try to spawn that object.");
            writer.comment("This setting doesn't affect growing saplings anymore.");
            writer.setting(WorldStandardValues.OBJECT_SPAWN_RATIO, this.objectSpawnRatio);
        }
        writer.bigTitle("Structures");
        writer.comment("Generate-structures in the server.properties file is ignored by Terrain Control. Use these settings instead.");
        writer.comment("");
        writer.smallTitle("Strongholds");
        writer.comment("Set this to false to prevent the stronghold generator from doing anything.");
        writer.setting(WorldStandardValues.STRONGHOLDS_ENABLED, this.strongholdsEnabled);
        writer.comment("The number of strongholds in the world.");
        writer.setting(WorldStandardValues.STRONGHOLD_COUNT, this.strongholdCount);
        writer.comment("How far strongholds are from the spawn and other strongholds (minimum is 1.0, default is 32.0).");
        writer.setting(WorldStandardValues.STRONGHOLD_DISTANCE, this.strongholdDistance);
        writer.comment("How concentrated strongholds are around the spawn (minimum is 1, default is 3). Lower number, lower concentration.");
        writer.setting(WorldStandardValues.STRONGHOLD_SPREAD, this.strongholdSpread);
        writer.smallTitle("Villages");
        writer.comment("Whether the villages are enabled or not.");
        writer.setting(WorldStandardValues.VILLAGES_ENABLED, this.villagesEnabled);
        writer.comment("The size of the village. Larger is bigger. Normal worlds have 0 as default, superflat worlds 1.");
        writer.setting(WorldStandardValues.VILLAGE_SIZE, this.villageSize);
        writer.comment("The minimum distance between the village centers in chunks. Minimum value is 9.");
        writer.setting(WorldStandardValues.VILLAGE_DISTANCE, this.villageDistance);
        writer.smallTitle("Rare buildings");
        writer.comment("Rare buildings are either desert pyramids, jungle temples or swamp huts.");
        writer.comment("Whether rare buildings are enabled.");
        writer.setting(WorldStandardValues.RARE_BUILDINGS_ENABLED, this.rareBuildingsEnabled);
        writer.comment("The minimum distance between rare buildings in chunks.");
        writer.setting(WorldStandardValues.MINIMUM_DISTANCE_BETWEEN_RARE_BUILDINGS, this.minimumDistanceBetweenRareBuildings);
        writer.comment("The maximum distance between rare buildings in chunks.");
        writer.setting(WorldStandardValues.MAXIMUM_DISTANCE_BETWEEN_RARE_BUILDINGS, this.maximumDistanceBetweenRareBuildings);
        writer.smallTitle("Other structures");
        writer.setting(WorldStandardValues.MINESHAFTS_ENABLED, this.mineshaftsEnabled);
        writer.setting(WorldStandardValues.NETHER_FORTRESSES_ENABLED, this.netherFortressesEnabled);
        writer.bigTitle("Visual settings");
        writer.comment("Warning this section will work only for players with the single version of Terrain Control installed.");
        writer.comment("World fog color");
        writer.setting(WorldStandardValues.WORLD_FOG, this.WorldFog);
        writer.comment("World night fog color");
        writer.setting(WorldStandardValues.WORLD_NIGHT_FOG, this.WorldNightFog);
        writer.bigTitle("Cave settings");
        writer.comment("This controls the odds that a given chunk will host a single cave and/or the start of a cave system.");
        writer.setting(WorldStandardValues.CAVE_RARITY, this.caveRarity);
        writer.comment("The number of times the cave generation algorithm will attempt to create single caves and cave");
        writer.comment("systems in the given chunk. This value is larger because the likelihood for the cave generation");
        writer.comment("algorithm to bailout is fairly high and it is used in a randomizer that trends towards lower");
        writer.comment("random numbers. With an input of 40 (default) the randomizer will result in an average random");
        writer.comment("result of 5 to 6. This can be turned off by setting evenCaveDistribution (below) to true.");
        writer.setting(WorldStandardValues.CAVE_FREQUENCY, this.caveFrequency);
        writer.comment("Sets the minimum and maximum altitudes at which caves will be generated. These values are");
        writer.comment("used in a randomizer that trends towards lower numbers so that caves become more frequent");
        writer.comment("the closer you get to the bottom of the map. Setting even cave distribution (above) to true");
        writer.comment("will turn off this randomizer and use a flat random number generator that will create an even");
        writer.comment("density of caves at all altitudes.");
        writer.setting(WorldStandardValues.CAVE_MIN_ALTITUDE, this.caveMinAltitude);
        writer.setting(WorldStandardValues.CAVE_MAX_ALTITUDE, this.caveMaxAltitude);
        writer.comment("The odds that the cave generation algorithm will generate a single cavern without an accompanying");
        writer.comment("cave system. Note that whenever the algorithm generates an individual cave it will also attempt to");
        writer.comment("generate a pocket of cave systems in the vicinity (no guarantee of connection or that the cave system");
        writer.comment("will actually be created).");
        writer.setting(WorldStandardValues.INDIVIDUAL_CAVE_RARITY, this.individualCaveRarity);
        writer.comment("The number of times the algorithm will attempt to start a cave system in a given chunk per cycle of");
        writer.comment("the cave generation algorithm (see cave frequency setting above). Note that setting this value too");
        writer.comment("high with an accompanying high cave frequency value can cause extremely long world generation time.");
        writer.setting(WorldStandardValues.CAVE_SYSTEM_FREQUENCY, this.caveSystemFrequency);
        writer.comment("This can be set to create an additional chance that a cave system pocket (a higher than normal");
        writer.comment("density of cave systems) being started in a given chunk. Normally, a cave pocket will only be");
        writer.comment("attempted if an individual cave is generated, but this will allow more cave pockets to be generated");
        writer.comment("in addition to the individual cave trigger.");
        writer.setting(WorldStandardValues.CAVE_SYSTEM_POCKET_CHANCE, this.caveSystemPocketChance);
        writer.comment("The minimum and maximum size that a cave system pocket can be. This modifies/overrides the");
        writer.comment("cave system frequency setting (above) when triggered.");
        writer.setting(WorldStandardValues.CAVE_SYSTEM_POCKET_MIN_SIZE, this.caveSystemPocketMinSize);
        writer.setting(WorldStandardValues.CAVE_SYSTEM_POCKET_MAX_SIZE, this.caveSystemPocketMaxSize);
        writer.comment("Setting this to true will turn off the randomizer for cave frequency (above). Do note that");
        writer.comment("if you turn this on you will probably want to adjust the cave frequency down to avoid long");
        writer.comment("load times at world creation.");
        writer.setting(WorldStandardValues.EVEN_CAVE_DISTRIBUTION, this.evenCaveDistribution);
        writer.bigTitle("Canyon settings");
        writer.setting(WorldStandardValues.CANYON_RARITY, this.canyonRarity);
        writer.setting(WorldStandardValues.CANYON_MIN_ALTITUDE, this.canyonMinAltitude);
        writer.setting(WorldStandardValues.CANYON_MAX_ALTITUDE, this.canyonMaxAltitude);
        writer.setting(WorldStandardValues.CANYON_MIN_LENGTH, this.canyonMinLength);
        writer.setting(WorldStandardValues.CANYON_MAX_LENGTH, this.canyonMaxLength);
        writer.setting(WorldStandardValues.CANYON_DEPTH, this.canyonDepth);
        writer.bigTitle("Settings for BiomeMode:OldGenerator");
        writer.comment("This generator works only with old terrain generator!");
        writer.setting(WorldStandardValues.OLD_BIOME_SIZE, this.oldBiomeSize);
        writer.setting(WorldStandardValues.MIN_MOISTURE, this.minMoisture);
        writer.setting(WorldStandardValues.MAX_MOISTURE, this.maxMoisture);
        writer.setting(WorldStandardValues.MIN_TEMPERATURE, this.minTemperature);
        writer.setting(WorldStandardValues.MAX_TEMPERATURE, this.maxTemperature);
    }

    private void WriteCustomBiomes(SettingsWriter writer) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        ArrayList<Map.Entry<String, Integer>> cbi = new ArrayList<Map.Entry<String, Integer>>(this.customBiomeGenerationIds.entrySet());
        Collections.sort(cbi, this.CBV);
        for (Map.Entry entry : cbi) {
            output.add((String)entry.getKey() + ":" + entry.getValue());
        }
        writer.setting(WorldStandardValues.CUSTOM_BIOMES, output);
    }

    public double getFractureHorizontal() {
        return this.fractureHorizontal < 0.0 ? 1.0 / (Math.abs(this.fractureHorizontal) + 1.0) : this.fractureHorizontal + 1.0;
    }

    public double getFractureVertical() {
        return this.fractureVertical < 0.0 ? 1.0 / (Math.abs(this.fractureVertical) + 1.0) : this.fractureVertical + 1.0;
    }

    public boolean createAdminium(int y) {
        return !this.disableBedrock && (!this.flatBedrock || y == 0);
    }

    public static enum ConfigMode {
        WriteAll,
        WriteDisable,
        WriteWithoutComments;

    }

    public static enum ImageOrientation {
        North,
        East,
        South,
        West;

    }

    public static enum ImageMode {
        Repeat,
        Mirror,
        ContinueNormal,
        FillEmpty;

    }

    public static enum TerrainMode {
        Normal,
        OldGenerator,
        TerrainTest,
        NotGenerate,
        Default;

    }
}

