/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration;

import com.khorn.terraincontrol.BiomeIds;
import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.BiomeConfigFinder;
import com.khorn.terraincontrol.configuration.BiomeLoadInstruction;
import com.khorn.terraincontrol.configuration.ConfigFile;
import com.khorn.terraincontrol.configuration.ConfigProvider;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.configuration.io.FileSettingsReader;
import com.khorn.terraincontrol.configuration.io.FileSettingsWriter;
import com.khorn.terraincontrol.configuration.io.MemorySettingsReader;
import com.khorn.terraincontrol.configuration.standard.BiomeStandardValues;
import com.khorn.terraincontrol.configuration.standard.StandardBiomeTemplate;
import com.khorn.terraincontrol.configuration.standard.WorldStandardValues;
import com.khorn.terraincontrol.customobjects.CustomObjectCollection;
import com.khorn.terraincontrol.customobjects.CustomObjectLoader;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.helpers.FileHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class WorldSettings
implements ConfigProvider {
    private static final int MAX_INHERITANCE_DEPTH = 15;
    private LocalWorld world;
    private File settingsDir;
    private CustomObjectCollection customObjects;
    public WorldConfig worldConfig;
    public LocalBiome[] biomes;
    private final Collection<LocalBiome> savedBiomes = new HashSet<LocalBiome>();
    private final boolean checkOnly;
    private int biomesCount;

    public WorldSettings(File settingsDir, LocalWorld world, boolean checkOnly) {
        this.settingsDir = settingsDir;
        this.world = world;
        this.checkOnly = checkOnly;
        this.loadCustomObjects();
        this.loadWorldConfig();
        this.biomes = new LocalBiome[world.getMaxBiomesCount()];
        this.loadBiomes();
    }

    private void loadCustomObjects() {
        File oldWorldObjectsDir = new File(this.settingsDir, "BOBPlugins");
        File worldObjectsDir = new File(this.settingsDir, "WorldObjects");
        if (!FileHelper.migrateFolder(oldWorldObjectsDir, worldObjectsDir)) {
            TerrainControl.log(LogMarker.WARN, "Failed to move old world custom objects from {} to {} in world {}. Please move the old objects manually.", oldWorldObjectsDir.getName(), worldObjectsDir.getName(), this.world.getName());
        }
        Map<String, CustomObjectLoader> objectLoaders = TerrainControl.getCustomObjectManager().getObjectLoaders();
        this.customObjects = new CustomObjectCollection(objectLoaders, worldObjectsDir);
        this.customObjects.setFallback(TerrainControl.getCustomObjectManager().getGlobalObjects());
        TerrainControl.log(LogMarker.INFO, "{} world custom objects loaded.", this.customObjects.getAll().size());
    }

    private void loadWorldConfig() {
        File worldConfigFile = new File(this.settingsDir, "WorldConfig.ini");
        this.worldConfig = new WorldConfig(new FileSettingsReader(this.world.getName(), worldConfigFile), this.world, this.customObjects);
        FileSettingsWriter.writeToFile(this.worldConfig, this.worldConfig.SettingsMode);
    }

    private void loadBiomes() {
        ArrayList<File> biomeDirs = new ArrayList<File>(2);
        biomeDirs.add(new File(this.settingsDir, this.correctOldBiomeConfigFolder(this.settingsDir)));
        biomeDirs.add(new File(TerrainControl.getEngine().getTCDataFolder(), "GlobalBiomes"));
        FileHelper.makeFolders(biomeDirs);
        HashSet<BiomeLoadInstruction> biomesToLoad = new HashSet<BiomeLoadInstruction>();
        biomesToLoad.addAll(this.world.getDefaultBiomes());
        for (Map.Entry<String, Integer> entry : this.worldConfig.customBiomeGenerationIds.entrySet()) {
            String biomeName = entry.getKey();
            int generationId = entry.getValue();
            biomesToLoad.add(new BiomeLoadInstruction(biomeName, generationId, new StandardBiomeTemplate(this.worldConfig.worldHeightScale)));
        }
        BiomeConfigFinder biomeConfigFinder = new BiomeConfigFinder(this.worldConfig, TerrainControl.getPluginConfig().biomeConfigExtension);
        Map<String, BiomeConfig> biomeConfigs = biomeConfigFinder.loadBiomesFromDirectories(biomeDirs, biomesToLoad);
        String loadedBiomeNames = this.readSettings(biomeConfigs);
        this.saveSettings();
        TerrainControl.log(LogMarker.INFO, "{} biomes Loaded", this.biomesCount);
        TerrainControl.log(LogMarker.DEBUG, "{}", loadedBiomeNames);
    }

    @Override
    public WorldConfig getWorldConfig() {
        return this.worldConfig;
    }

    @Override
    public LocalBiome getBiomeByIdOrNull(int id) {
        if (id < 0 || id > this.biomes.length) {
            return null;
        }
        return this.biomes[id];
    }

    @Override
    public void reload() {
        Arrays.fill(this.biomes, null);
        this.savedBiomes.clear();
        this.biomesCount = 0;
        this.loadCustomObjects();
        this.loadWorldConfig();
        this.loadBiomes();
    }

    private String readSettings(Map<String, BiomeConfig> biomeConfigs) {
        StringBuilder loadedBiomeNames = new StringBuilder();
        for (BiomeConfig biomeConfig : biomeConfigs.values()) {
            LocalBiome biome;
            if (biomeConfig == null) continue;
            ++this.biomesCount;
            loadedBiomeNames.append(biomeConfig.getName());
            loadedBiomeNames.append(", ");
            this.processInheritance(biomeConfigs, biomeConfig, 0);
            biomeConfig.process();
            if (this.checkOnly) continue;
            int generationId = biomeConfig.generationId;
            if (generationId < 0 || generationId >= this.world.getMaxBiomesCount()) {
                TerrainControl.log(LogMarker.ERROR, "The biome id of the {} biome, {}, is too high. It must be between 0 and {}, inclusive.", biomeConfig.getName(), generationId, this.world.getMaxBiomesCount() - 1);
                TerrainControl.log(LogMarker.ERROR, "The biome has been prevented from loading.", new Object[0]);
                continue;
            }
            if (this.biomes[generationId] != null) {
                TerrainControl.log(LogMarker.FATAL, "Duplicate biome id {} ({} and {})!", generationId, this.biomes[generationId].getName(), biomeConfig.getName());
                TerrainControl.log(LogMarker.FATAL, "The biome {} has been prevented from loading.", biomeConfig.getName());
                TerrainControl.log(LogMarker.INFO, "If you are updating an old pre-Minecraft 1.7 world, please read this wiki page:", new Object[0]);
                TerrainControl.log(LogMarker.INFO, "https://github.com/Wickth/TerrainControl/wiki/Upgrading-an-old-map-to-Minecraft-1.7", new Object[0]);
                continue;
            }
            int savedId = biomeConfig.generationId;
            if (!biomeConfig.replaceToBiomeName.isEmpty()) {
                BiomeConfig replaceToConfig = biomeConfigs.get(biomeConfig.replaceToBiomeName);
                if (replaceToConfig == null) {
                    biomeConfig.replaceToBiomeName = "";
                    TerrainControl.log(LogMarker.WARN, "Invalid ReplaceToBiomeName in biome {}: biome {} doesn't exist", biomeConfig.getName(), biomeConfig.replaceToBiomeName);
                } else {
                    savedId = replaceToConfig.generationId;
                }
            }
            if (savedId >= this.world.getMaxSavedBiomesCount()) {
                TerrainControl.log(LogMarker.ERROR, "Biomes with an id between {} and {} (inclusive) must have a valid ReplaceToBiomeName setting:", this.world.getMaxBiomesCount(), this.world.getMaxSavedBiomesCount() - 1);
                TerrainControl.log(LogMarker.ERROR, "Minecraft can only save biomes with an id between 0 and {}, inclusive.", this.world.getMaxBiomesCount() - 1);
                TerrainControl.log(LogMarker.ERROR, "This means that the biome {} with map file id {} had to be prevented from loading.", biomeConfig.getName(), savedId);
                continue;
            }
            this.biomes[biome.getIds().getGenerationId()] = biome = this.world.createBiomeFor(biomeConfig, new BiomeIds(generationId, savedId));
            if (!biome.getIds().isVirtual()) {
                this.savedBiomes.add(biome);
            }
            if (!this.worldConfig.BiomeConfigsHaveReplacement) {
                this.worldConfig.BiomeConfigsHaveReplacement = biomeConfig.replacedBlocks.hasReplaceSettings();
            }
            if (this.worldConfig.NormalBiomes.contains(biomeConfig.getName())) {
                this.worldConfig.normalBiomesRarity += biomeConfig.biomeRarity;
            }
            if (this.worldConfig.IceBiomes.contains(biomeConfig.getName())) {
                this.worldConfig.iceBiomesRarity += biomeConfig.biomeRarity;
            }
            if (this.worldConfig.maxSmoothRadius < biomeConfig.smoothRadius) {
                this.worldConfig.maxSmoothRadius = biomeConfig.smoothRadius;
            }
            if (this.worldConfig.biomeMode == TerrainControl.getBiomeModeManager().FROM_IMAGE) {
                if (this.worldConfig.biomeColorMap == null) {
                    this.worldConfig.biomeColorMap = new HashMap();
                }
                int color = biomeConfig.biomeColor;
                this.worldConfig.biomeColorMap.put(color, biome.getIds().getGenerationId());
            }
            biome.setEffects();
        }
        if (this.biomesCount > 0) {
            loadedBiomeNames.delete(loadedBiomeNames.length() - 2, loadedBiomeNames.length());
        }
        return loadedBiomeNames.toString();
    }

    private void saveSettings() {
        for (LocalBiome biome : this.biomes) {
            if (biome == null) continue;
            biome.getBiomeConfig().outputToFile();
        }
    }

    private void processInheritance(Map<String, BiomeConfig> allBiomeConfigs, BiomeConfig biomeConfig, int currentDepth) {
        if (biomeConfig.biomeExtendsProcessed) {
            return;
        }
        String extendedBiomeName = biomeConfig.biomeExtends;
        if (extendedBiomeName == null || extendedBiomeName.length() == 0) {
            biomeConfig.biomeExtendsProcessed = true;
            return;
        }
        BiomeConfig extendedBiomeConfig = allBiomeConfigs.get(extendedBiomeName);
        if (extendedBiomeConfig == null) {
            TerrainControl.log(LogMarker.WARN, "The biome {} tried to extend the biome {}, but that biome doesn't exist.", biomeConfig.getName(), extendedBiomeName);
            return;
        }
        if (currentDepth > 15) {
            TerrainControl.log(LogMarker.FATAL, "The biome {} cannot extend the biome {} - too much configs processed already! Cyclical inheritance?", biomeConfig.getName(), extendedBiomeConfig.getName());
        }
        if (!extendedBiomeConfig.biomeExtendsProcessed) {
            this.processInheritance(allBiomeConfigs, extendedBiomeConfig, currentDepth + 1);
        }
        biomeConfig.merge(extendedBiomeConfig);
        biomeConfig.biomeExtendsProcessed = true;
    }

    public WorldSettings(DataInputStream stream, LocalWorld world) throws IOException {
        int id;
        this.checkOnly = false;
        this.customObjects = TerrainControl.getCustomObjectManager().getGlobalObjects();
        MemorySettingsReader worldSettingsReader = new MemorySettingsReader(world.getName());
        worldSettingsReader.putSetting(WorldStandardValues.WORLD_FOG, stream.readInt());
        worldSettingsReader.putSetting(WorldStandardValues.WORLD_NIGHT_FOG, stream.readInt());
        this.worldConfig = new WorldConfig(worldSettingsReader, world, this.customObjects);
        int count = stream.readInt();
        while (count-- > 0) {
            String biomeName = ConfigFile.readStringFromStream(stream);
            id = stream.readInt();
            this.worldConfig.customBiomeGenerationIds.put(biomeName, id);
        }
        StandardBiomeTemplate defaultSettings = new StandardBiomeTemplate(this.worldConfig.worldHeightCap);
        this.biomes = new LocalBiome[world.getMaxBiomesCount()];
        count = stream.readInt();
        while (count-- > 0) {
            LocalBiome biome;
            id = stream.readInt();
            String biomeName = ConfigFile.readStringFromStream(stream);
            MemorySettingsReader biomeReader = new MemorySettingsReader(biomeName);
            biomeReader.putSetting(BiomeStandardValues.BIOME_TEMPERATURE, Float.valueOf(stream.readFloat()));
            biomeReader.putSetting(BiomeStandardValues.BIOME_WETNESS, Float.valueOf(stream.readFloat()));
            biomeReader.putSetting(BiomeStandardValues.SKY_COLOR, stream.readInt());
            biomeReader.putSetting(BiomeStandardValues.WATER_COLOR, stream.readInt());
            biomeReader.putSetting(BiomeStandardValues.GRASS_COLOR, stream.readInt());
            biomeReader.putSetting(BiomeStandardValues.GRASS_COLOR_IS_MULTIPLIER, stream.readBoolean());
            biomeReader.putSetting(BiomeStandardValues.FOLIAGE_COLOR, stream.readInt());
            biomeReader.putSetting(BiomeStandardValues.FOLIAGE_COLOR_IS_MULTIPLIER, stream.readBoolean());
            BiomeLoadInstruction instruction = new BiomeLoadInstruction(biomeName, id, defaultSettings);
            BiomeConfig config = new BiomeConfig(biomeReader, instruction, this.worldConfig);
            config.process();
            this.biomes[id] = biome = world.createBiomeFor(config, new BiomeIds(id));
            biome.setEffects();
        }
        this.savedBiomes.addAll(Arrays.asList(this.biomes));
    }

    private String correctOldBiomeConfigFolder(File settingsDir) {
        String biomeFolderName = "WorldBiomes";
        File oldBiomeConfigs = new File(settingsDir, "BiomeConfigs");
        if (oldBiomeConfigs.exists() && !oldBiomeConfigs.renameTo(new File(settingsDir, biomeFolderName))) {
            TerrainControl.log(LogMarker.WARN, "========================", new Object[0]);
            TerrainControl.log(LogMarker.WARN, "Fould old `BiomeConfigs` folder, but it could not be renamed to `", biomeFolderName, "`!");
            TerrainControl.log(LogMarker.WARN, "Please rename the folder manually.", new Object[0]);
            TerrainControl.log(LogMarker.WARN, "========================", new Object[0]);
            biomeFolderName = "BiomeConfigs";
        }
        return biomeFolderName;
    }

    @Override
    public void writeToStream(DataOutputStream stream) throws IOException {
        ConfigFile.writeStringToStream(stream, this.worldConfig.getName());
        stream.writeInt(this.worldConfig.WorldFog);
        stream.writeInt(this.worldConfig.WorldNightFog);
        ArrayList<LocalBiome> nonVirtualCustomBiomes = new ArrayList<LocalBiome>(this.worldConfig.customBiomeGenerationIds.size());
        for (Integer generationId : this.worldConfig.customBiomeGenerationIds.values()) {
            LocalBiome biome = this.biomes[generationId];
            if (biome.getIds().isVirtual()) continue;
            nonVirtualCustomBiomes.add(biome);
        }
        stream.writeInt(nonVirtualCustomBiomes.size());
        for (LocalBiome biome : nonVirtualCustomBiomes) {
            ConfigFile.writeStringToStream(stream, biome.getName());
            stream.writeInt(biome.getIds().getSavedId());
        }
        stream.writeInt(this.savedBiomes.size());
        for (LocalBiome biome : this.savedBiomes) {
            if (biome == null) continue;
            stream.writeInt(biome.getIds().getSavedId());
            biome.getBiomeConfig().writeToStream(stream);
        }
    }

    @Override
    public LocalBiome[] getBiomeArray() {
        return this.biomes;
    }

    @Override
    public CustomObjectCollection getCustomObjects() {
        return this.customObjects;
    }
}

