/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration.io;

import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.configuration.io.SettingsReader;
import com.khorn.terraincontrol.configuration.settingType.Setting;
import com.khorn.terraincontrol.util.helpers.InheritanceHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MemorySettingsReader
implements SettingsReader {
    private final List<ConfigFunction<?>> configFunctions = new ArrayList();
    private SettingsReader fallback;
    private final String name;
    private final Map<Setting<?>, Object> settings = new HashMap();

    public MemorySettingsReader(String name) {
        this.name = name;
    }

    @Override
    public <T> void addConfigFunction(ConfigFunction<T> function) {
        this.configFunctions.add(function);
    }

    @Override
    public <T> List<ConfigFunction<T>> getConfigFunctions(T holder, boolean useFallback) {
        List<ConfigFunction<T>> functions = this.configFunctions;
        if (useFallback && this.fallback != null) {
            return InheritanceHelper.mergeLists(functions, this.fallback.getConfigFunctions(holder, true));
        }
        return functions;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Iterable<Map.Entry<String, String>> getRawSettings() {
        return Collections.emptyList();
    }

    @Override
    public <S> S getSetting(Setting<S> setting, S defaultValue) {
        Object value = this.settings.get(setting);
        if (value != null) {
            return (S)value;
        }
        if (this.fallback != null) {
            return this.fallback.getSetting(setting, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public boolean hasSetting(Setting<?> setting) {
        return this.settings.containsKey(setting);
    }

    @Override
    public boolean isNewConfig() {
        return true;
    }

    @Override
    public <S> void putSetting(Setting<S> setting, S value) {
        this.settings.put(setting, value);
    }

    @Override
    public void renameOldSetting(String oldValue, Setting<?> newValue) {
    }

    @Override
    public void setFallbackReader(SettingsReader reader) {
        this.fallback = reader;
    }
}

