/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration.settingType;

import com.khorn.terraincontrol.configuration.settingType.Setting;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.generator.surface.MesaSurfaceGenerator;
import com.khorn.terraincontrol.generator.surface.NullSurfaceGenerator;
import com.khorn.terraincontrol.generator.surface.SimpleSurfaceGenerator;
import com.khorn.terraincontrol.generator.surface.SurfaceGenerator;
import com.khorn.terraincontrol.util.helpers.StringHelper;

class SurfaceGeneratorSetting
extends Setting<SurfaceGenerator> {
    SurfaceGeneratorSetting(String name) {
        super(name);
    }

    @Override
    public SurfaceGenerator getDefaultValue() {
        return new NullSurfaceGenerator();
    }

    @Override
    public SurfaceGenerator read(String string) throws InvalidConfigException {
        if (string.length() > 0) {
            MesaSurfaceGenerator mesa = MesaSurfaceGenerator.getFor(string);
            if (mesa != null) {
                return mesa;
            }
            String[] parts = StringHelper.readCommaSeperatedString(string);
            return new SimpleSurfaceGenerator(parts);
        }
        return new NullSurfaceGenerator();
    }
}

