/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.customobjects.Branch;
import com.khorn.terraincontrol.customobjects.CustomObjectCoordinate;
import com.khorn.terraincontrol.customobjects.StructurePartSpawnHeight;
import com.khorn.terraincontrol.customobjects.StructuredCustomObject;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.helpers.RandomHelper;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class CustomObjectStructure {
    protected final Random random;
    protected LocalWorld world;
    protected CustomObjectCoordinate start;
    protected StructurePartSpawnHeight height;
    protected Map<ChunkCoordinate, Set<CustomObjectCoordinate>> objectsToSpawn;
    protected int maxBranchDepth;

    public CustomObjectStructure(LocalWorld world, CustomObjectCoordinate start) {
        if (!(start.getObject() instanceof StructuredCustomObject)) {
            throw new IllegalArgumentException("Start object has to be a structure!");
        }
        this.world = world;
        this.start = start;
        this.height = start.getStructuredObject().getStructurePartSpawnHeight();
        this.maxBranchDepth = start.getStructuredObject().getMaxBranchDepth();
        this.random = RandomHelper.getRandomForCoords(start.getX(), start.getY(), start.getZ(), world.getSeed());
        this.objectsToSpawn = new LinkedHashMap<ChunkCoordinate, Set<CustomObjectCoordinate>>();
        this.addToSpawnList(start);
        this.addBranches(start, 1);
    }

    private void addBranches(CustomObjectCoordinate coordObject, int depth) {
        for (Branch branch : coordObject.getStructuredObject().getBranches(coordObject.getRotation())) {
            CustomObjectCoordinate childCoordObject = branch.toCustomObjectCoordinate(this.world, this.random, coordObject.getX(), coordObject.getY(), coordObject.getZ());
            if (childCoordObject == null) continue;
            this.addToSpawnList(childCoordObject);
            if (depth >= this.maxBranchDepth) continue;
            this.addBranches(childCoordObject, depth + 1);
        }
    }

    void addToSpawnList(CustomObjectCoordinate coordObject) {
        ChunkCoordinate chunkCoordinate = coordObject.getPopulatingChunk();
        Set<CustomObjectCoordinate> objectsInChunk = this.objectsToSpawn.get(chunkCoordinate);
        if (objectsInChunk == null) {
            objectsInChunk = new LinkedHashSet<CustomObjectCoordinate>();
            this.objectsToSpawn.put(chunkCoordinate, objectsInChunk);
        }
        objectsInChunk.add(coordObject);
    }

    public void spawnForChunk(ChunkCoordinate chunkCoordinate) {
        Set<CustomObjectCoordinate> objectsInChunk = this.objectsToSpawn.get(chunkCoordinate);
        if (objectsInChunk != null) {
            for (CustomObjectCoordinate coordObject : objectsInChunk) {
                coordObject.spawnWithChecks(this.world, this.height, this.random);
            }
        }
    }
}

