/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.customobjects.CustomObjectCoordinate;
import com.khorn.terraincontrol.customobjects.CustomObjectStructure;
import com.khorn.terraincontrol.generator.resource.CustomStructureGen;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.helpers.RandomHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class CustomObjectStructureCache {
    private Map<ChunkCoordinate, CustomObjectStructure> structureCache;
    private LocalWorld world;

    public CustomObjectStructureCache(LocalWorld world) {
        this.world = world;
        this.structureCache = new HashMap<ChunkCoordinate, CustomObjectStructure>();
    }

    public void reload(LocalWorld world) {
        this.world = world;
        this.structureCache.clear();
    }

    public CustomObjectStructure getStructureStart(int chunkX, int chunkZ) {
        CustomObjectCoordinate customObject;
        ChunkCoordinate coord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
        CustomObjectStructure structureStart = this.structureCache.get(coord);
        if (this.structureCache.size() > 400) {
            this.structureCache.clear();
        }
        if (structureStart != null) {
            return structureStart;
        }
        Random random = RandomHelper.getRandomForCoords(chunkX ^ 2, (chunkZ + 1) * 2, this.world.getSeed());
        CustomStructureGen structureGen = this.world.getBiome((int)(chunkX * 16 + 15), (int)(chunkZ * 16 + 15)).getBiomeConfig().structureGen;
        if (structureGen != null && (customObject = structureGen.getRandomObjectCoordinate(random, chunkX, chunkZ)) != null) {
            structureStart = new CustomObjectStructure(this.world, customObject);
            this.structureCache.put(coord, structureStart);
            return structureStart;
        }
        return null;
    }
}

