/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.configuration.io.SettingsReader;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.CustomObjectCollection;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.Rotation;
import java.util.Map;
import java.util.Random;

public class UseWorld
implements CustomObject {
    @Override
    public void onEnable(Map<String, CustomObject> otherObjectsInDirectory) {
    }

    @Override
    public String getName() {
        return "UseWorld";
    }

    @Override
    public boolean canSpawnAsTree() {
        return true;
    }

    @Override
    public boolean canSpawnAsObject() {
        return true;
    }

    @Override
    public boolean spawnForced(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        for (CustomObject object : world.getConfigs().getCustomObjects()) {
            if (!object.hasPreferenceToSpawnIn(world.getBiome(x, z)) || !object.spawnForced(world, random, rotation, x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean spawnAsTree(LocalWorld world, Random random, int x, int z) {
        WorldConfig worldConfig = world.getConfigs().getWorldConfig();
        CustomObjectCollection customObjects = world.getConfigs().getCustomObjects();
        if (customObjects.isEmpty()) {
            return false;
        }
        boolean objectSpawned = false;
        int spawnattemps = 0;
        while (!objectSpawned) {
            if (spawnattemps > worldConfig.objectSpawnRatio) {
                return false;
            }
            ++spawnattemps;
            CustomObject selectedObject = customObjects.getRandomObject(random);
            if (!selectedObject.hasPreferenceToSpawnIn(world.getBiome(x, z))) continue;
            objectSpawned = selectedObject.spawnAsTree(world, random, x, z);
        }
        return objectSpawned;
    }

    @Override
    public boolean process(LocalWorld world, Random rand, ChunkCoordinate chunkCoord) {
        WorldConfig worldConfig = world.getConfigs().getWorldConfig();
        CustomObjectCollection customObjects = world.getConfigs().getCustomObjects();
        if (customObjects.isEmpty()) {
            return false;
        }
        boolean objectSpawned = false;
        int spawnattemps = 0;
        while (!objectSpawned) {
            if (spawnattemps > worldConfig.objectSpawnRatio) {
                return false;
            }
            ++spawnattemps;
            CustomObject selectedObject = customObjects.getRandomObject(rand);
            if (!selectedObject.hasPreferenceToSpawnIn(world.getBiome(chunkCoord.getBlockXCenter(), chunkCoord.getBlockZCenter()))) continue;
            objectSpawned = selectedObject.process(world, rand, chunkCoord);
        }
        return objectSpawned;
    }

    @Override
    public CustomObject applySettings(SettingsReader settings) {
        return this;
    }

    @Override
    public boolean hasPreferenceToSpawnIn(LocalBiome biome) {
        return false;
    }

    @Override
    public boolean canSpawnAt(LocalWorld world, Rotation rotation, int x, int y, int z) {
        return true;
    }

    @Override
    public boolean canRotateRandomly() {
        return true;
    }
}

