/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects.bo3;

import com.khorn.terraincontrol.configuration.ConfigFile;
import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.configuration.io.SettingsReader;
import com.khorn.terraincontrol.configuration.io.SettingsWriter;
import com.khorn.terraincontrol.configuration.standard.WorldStandardValues;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.bo3.BO3Check;
import com.khorn.terraincontrol.customobjects.bo3.BO3Function;
import com.khorn.terraincontrol.customobjects.bo3.BO3Settings;
import com.khorn.terraincontrol.customobjects.bo3.BlockFunction;
import com.khorn.terraincontrol.customobjects.bo3.BranchFunction;
import com.khorn.terraincontrol.customobjects.bo3.WeightedBranchFunction;
import com.khorn.terraincontrol.util.BoundingBox;
import com.khorn.terraincontrol.util.MaterialSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class BO3Config
extends ConfigFile {
    public Map<String, CustomObject> otherObjectsInDirectory;
    public String author;
    public String description;
    public WorldConfig.ConfigMode settingsMode;
    public boolean tree;
    public int frequency;
    public double rarity;
    public boolean rotateRandomly;
    public BO3Settings.SpawnHeightEnum spawnHeight;
    public int minHeight;
    public int maxHeight;
    public ArrayList<String> excludedBiomes;
    public MaterialSet sourceBlocks;
    public int maxPercentageOutsideSourceBlock;
    public BO3Settings.OutsideSourceBlock outsideSourceBlock;
    public BlockFunction[][] blocks = new BlockFunction[4][];
    public BO3Check[][] bo3Checks = new BO3Check[4][];
    public int maxBranchDepth;
    public BranchFunction[][] branches = new BranchFunction[4][];
    public BoundingBox[] boundingBoxes = new BoundingBox[4];

    public BO3Config(SettingsReader reader, Map<String, CustomObject> otherObjectsInDirectory) {
        super(reader);
        this.otherObjectsInDirectory = otherObjectsInDirectory;
        this.readConfigSettings();
        this.correctSettings();
        this.rotateBlocksAndChecks();
    }

    @Override
    protected void writeConfigSettings(SettingsWriter writer) throws IOException {
        writer.bigTitle("BO3 object");
        writer.comment("This is the config file of a custom object.");
        writer.comment("If you add this object correctly to your BiomeConfigs, it will spawn in the world.");
        writer.comment("");
        writer.comment("This is the creator of this BO3 object");
        writer.setting(BO3Settings.AUTHOR, this.author);
        writer.comment("A short description of this BO3 object");
        writer.setting(BO3Settings.DESCRIPTION, this.description);
        writer.comment("The BO3 version, don't change this! It can be used by external applications to do a version check.");
        writer.setting(BO3Settings.VERSION, "3");
        writer.comment("The settings mode, WriteAll, WriteWithoutComments or WriteDisable. See WorldConfig.");
        writer.setting(WorldStandardValues.SETTINGS_MODE, this.settingsMode);
        writer.bigTitle("Main settings");
        writer.comment("This needs to be set to true to spawn the object in the Tree and Sapling resources.");
        writer.setting(BO3Settings.TREE, this.tree);
        writer.comment("The frequency of the BO3 from 1 to 200. Tries this many times to spawn this BO3 when using the CustomObject(...) resource.");
        writer.comment("Ignored by Tree(..), Sapling(..) and CustomStructure(..)");
        writer.setting(BO3Settings.FREQUENCY, this.frequency);
        writer.comment("The rarity of the BO3 from 0 to 100. Each spawn attempt has rarity% chance to succeed when using the CustomObject(...) resource.");
        writer.comment("Ignored by Tree(..), Sapling(..) and CustomStructure(..)");
        writer.setting(BO3Settings.RARITY, this.rarity);
        writer.comment("If you set this to true, the BO3 will be placed with a random rotation.");
        writer.setting(BO3Settings.ROTATE_RANDOMLY, this.rotateRandomly);
        writer.comment("The spawn height of the BO3 - randomY, highestBlock or highestSolidBlock.");
        writer.setting(BO3Settings.SPAWN_HEIGHT, this.spawnHeight);
        writer.comment("The height limits for the BO3.");
        writer.setting(BO3Settings.MIN_HEIGHT, this.minHeight);
        writer.setting(BO3Settings.MAX_HEIGHT, this.maxHeight);
        writer.comment("Objects can have other objects attacthed to it: branches. Branches can also");
        writer.comment("have branches attached to it, which can also have branches, etc. This is the");
        writer.comment("maximum branch depth for this objects.");
        writer.setting(BO3Settings.MAX_BRANCH_DEPTH, this.maxBranchDepth);
        writer.comment("When spawned with the UseWorld keyword, this BO3 should NOT spawn in the following biomes.");
        writer.comment("If you writer.write the BO3 name directly in the BiomeConfigs, this will be ignored.");
        writer.setting(BO3Settings.EXCLUDED_BIOMES, this.excludedBiomes);
        writer.bigTitle("Source block settings");
        writer.comment("The block(s) the BO3 should spawn in.");
        writer.setting(BO3Settings.SOURCE_BLOCKS, this.sourceBlocks);
        writer.comment("The maximum percentage of the BO3 that can be outside the SourceBlock.");
        writer.comment("The BO3 won't be placed on a location with more blocks outside the SourceBlock than this percentage.");
        writer.setting(BO3Settings.MAX_PERCENTAGE_OUTSIDE_SOURCE_BLOCK, this.maxPercentageOutsideSourceBlock);
        writer.comment("What to do when a block is about to be placed outside the SourceBlock? (dontPlace, placeAnyway)");
        writer.setting(BO3Settings.OUTSIDE_SOURCE_BLOCK, this.outsideSourceBlock);
        this.writeResources(writer);
    }

    @Override
    protected void readConfigSettings() {
        this.author = this.readSettings(BO3Settings.AUTHOR);
        this.description = this.readSettings(BO3Settings.DESCRIPTION);
        this.settingsMode = this.readSettings(WorldStandardValues.SETTINGS_MODE);
        this.tree = this.readSettings(BO3Settings.TREE);
        this.frequency = this.readSettings(BO3Settings.FREQUENCY);
        this.rarity = this.readSettings(BO3Settings.RARITY);
        this.rotateRandomly = this.readSettings(BO3Settings.ROTATE_RANDOMLY);
        this.spawnHeight = this.readSettings(BO3Settings.SPAWN_HEIGHT);
        this.minHeight = this.readSettings(BO3Settings.MIN_HEIGHT);
        this.maxHeight = this.readSettings(BO3Settings.MAX_HEIGHT);
        this.maxBranchDepth = this.readSettings(BO3Settings.MAX_BRANCH_DEPTH);
        this.excludedBiomes = new ArrayList(this.readSettings(BO3Settings.EXCLUDED_BIOMES));
        this.sourceBlocks = this.readSettings(BO3Settings.SOURCE_BLOCKS);
        this.maxPercentageOutsideSourceBlock = this.readSettings(BO3Settings.MAX_PERCENTAGE_OUTSIDE_SOURCE_BLOCK);
        this.outsideSourceBlock = this.readSettings(BO3Settings.OUTSIDE_SOURCE_BLOCK);
        this.readResources();
    }

    private void readResources() {
        BoundingBox box = BoundingBox.newEmptyBox();
        ArrayList<BlockFunction> tempBlocksList = new ArrayList<BlockFunction>();
        ArrayList<BO3Check> tempChecksList = new ArrayList<BO3Check>();
        ArrayList<BranchFunction> tempBranchesList = new ArrayList<BranchFunction>();
        for (ConfigFunction<BO3Config> res : this.reader.getConfigFunctions(this, true)) {
            if (!res.isValid()) continue;
            if (res instanceof BlockFunction) {
                BlockFunction block = (BlockFunction)res;
                box.expandToFit(block.x, block.y, block.z);
                tempBlocksList.add(block);
                continue;
            }
            if (res instanceof BO3Check) {
                tempChecksList.add((BO3Check)res);
                continue;
            }
            if (res instanceof WeightedBranchFunction) {
                tempBranchesList.add((WeightedBranchFunction)res);
                continue;
            }
            if (!(res instanceof BranchFunction)) continue;
            tempBranchesList.add((BranchFunction)res);
        }
        this.blocks[0] = tempBlocksList.toArray(new BlockFunction[tempBlocksList.size()]);
        this.bo3Checks[0] = tempChecksList.toArray(new BO3Check[tempChecksList.size()]);
        this.branches[0] = tempBranchesList.toArray(new BranchFunction[tempBranchesList.size()]);
        this.boundingBoxes[0] = box;
    }

    public void writeResources(SettingsWriter writer) throws IOException {
        writer.bigTitle("Blocks");
        writer.comment("All the blocks used in the BO3 are listed here. Possible blocks:");
        writer.comment("Block(x,y,z,id[.data][,nbtfile.nbt)");
        writer.comment("RandomBlock(x,y,z,id[:data][,nbtfile.nbt],chance[,id[:data][,nbtfile.nbt],chance[,...]])");
        writer.comment("So RandomBlock(0,0,0,CHEST,chest.nbt,50,CHEST,anotherchest.nbt,100) will spawn a chest at");
        writer.comment("the BO3 origin, and give it a 50% chance to have the contents of chest.nbt, or, if that");
        writer.comment("fails, a 100% percent chance to have the contents of anotherchest.nbt.");
        for (BlockFunction blockFunction : this.blocks[0]) {
            writer.function(blockFunction);
        }
        writer.bigTitle("BO3 checks");
        writer.comment("Require a condition at a certain location in order for the BO3 to be spawned.");
        writer.comment("BlockCheck(x,y,z,BlockName[,BlockName[,...]]) - one of the blocks must be at the location");
        writer.comment("BlockCheckNot(x,y,z,BlockName[,BlockName[,...]]) - all the blocks must not be at the location");
        writer.comment("LightCheck(x,y,z,minLightLevel,maxLightLevel) - light must be between min and max (inclusive)");
        writer.comment("");
        writer.comment("You can use \"Solid\" as a BlockName for matching all solid blocks or \"All\" to match all blocks that aren't air.");
        writer.comment("");
        writer.comment("Examples:");
        writer.comment("  BlockCheck(0,-1,0,GRASS,DIRT)  Require grass or dirt just below the object");
        writer.comment("  BlockCheck(0,-1,0,Solid)       Require any solid block just below the object");
        writer.comment("  BlockCheck(0,-1,0,WOOL)        Require any type of wool just below the object");
        writer.comment("  BlockCheck(0,-1,0,WOOL:0)      Require white wool just below the object");
        writer.comment("  BlockCheckNot(0,-1,0,WOOL:0)   Require that there is no white wool below the object");
        writer.comment("  LightCheck(0,0,0,0,1)          Require almost complete darkness just below the object");
        for (BO3Function bO3Function : this.bo3Checks[0]) {
            writer.function(bO3Function);
        }
        writer.bigTitle("Branches");
        writer.comment("Branches are objects that will spawn when this object spawns when it is used in");
        writer.comment("the CustomStructure resource. Branches can also have branches, making complex");
        writer.comment("structures possible. See the wiki for more details.");
        writer.comment("");
        writer.comment("Regular Branches spawn each branch with an independent chance of spawning.");
        writer.comment("Branch(x,y,z,branchName,rotation,chance[,anotherBranchName,rotation,chance[,...]][IndividualChance])");
        writer.comment("branchName - name of the object to spawn.");
        writer.comment("rotation - NORTH, SOUTH, EAST or WEST.");
        writer.comment("IndividualChance - The chance each branch has to spawn, assumed to be 100 when left blank");
        writer.comment("");
        writer.comment("Weighted Branches spawn branches with a dependent chance of spawning.");
        writer.comment("WeightedBranch(x,y,z,branchName,rotation,chance[,anotherBranchName,rotation,chance[,...]][MaxChanceOutOf])");
        writer.comment("MaxChanceOutOf - The chance all branches have to spawn out of, assumed to be 100 when left blank");
        for (BO3Function bO3Function : this.branches[0]) {
            writer.function(bO3Function);
        }
    }

    @Override
    protected void correctSettings() {
        this.maxHeight = this.higherThan(this.maxHeight, this.minHeight);
    }

    @Override
    protected void renameOldSettings() {
    }

    public void rotateBlocksAndChecks() {
        for (int i = 1; i < 4; ++i) {
            int j;
            this.blocks[i] = new BlockFunction[this.blocks[i - 1].length];
            for (j = 0; j < this.blocks[i].length; ++j) {
                this.blocks[i][j] = this.blocks[i - 1][j].rotate();
            }
            this.bo3Checks[i] = new BO3Check[this.bo3Checks[i - 1].length];
            for (j = 0; j < this.bo3Checks[i].length; ++j) {
                this.bo3Checks[i][j] = this.bo3Checks[i - 1][j].rotate();
            }
            this.branches[i] = new BranchFunction[this.branches[i - 1].length];
            for (j = 0; j < this.branches[i].length; ++j) {
                this.branches[i][j] = this.branches[i - 1][j].rotate();
            }
            this.boundingBoxes[i] = this.boundingBoxes[i - 1].rotate();
        }
    }
}

