/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects.bo3;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.CustomObjectLoader;
import com.khorn.terraincontrol.customobjects.bo3.BO3;
import com.khorn.terraincontrol.customobjects.bo3.BlockCheck;
import com.khorn.terraincontrol.customobjects.bo3.BlockCheckNot;
import com.khorn.terraincontrol.customobjects.bo3.BlockFunction;
import com.khorn.terraincontrol.customobjects.bo3.BranchFunction;
import com.khorn.terraincontrol.customobjects.bo3.LightCheck;
import com.khorn.terraincontrol.customobjects.bo3.RandomBlockFunction;
import com.khorn.terraincontrol.customobjects.bo3.WeightedBranchFunction;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.NamedBinaryTag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class BO3Loader
implements CustomObjectLoader {
    private static Map<String, NamedBinaryTag> loadedTags = new HashMap<String, NamedBinaryTag>();

    public BO3Loader() {
        TerrainControl.getConfigFunctionsManager().registerConfigFunction("Block", BlockFunction.class);
        TerrainControl.getConfigFunctionsManager().registerConfigFunction("Branch", BranchFunction.class);
        TerrainControl.getConfigFunctionsManager().registerConfigFunction("WeightedBranch", WeightedBranchFunction.class);
        TerrainControl.getConfigFunctionsManager().registerConfigFunction("RandomBlock", RandomBlockFunction.class);
        TerrainControl.getConfigFunctionsManager().registerConfigFunction("BlockCheck", BlockCheck.class);
        TerrainControl.getConfigFunctionsManager().registerConfigFunction("BlockCheckNot", BlockCheckNot.class);
        TerrainControl.getConfigFunctionsManager().registerConfigFunction("LightCheck", LightCheck.class);
    }

    @Override
    public CustomObject loadFromFile(String objectName, File file) {
        return new BO3(objectName, file);
    }

    public static NamedBinaryTag loadMetadata(String name, File bo3File) {
        NamedBinaryTag[] values;
        NamedBinaryTag metadata;
        String path = bo3File.getParent() + File.separator + name;
        if (loadedTags.containsKey(path)) {
            return loadedTags.get(path);
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(path);
            metadata = NamedBinaryTag.readFrom(stream, true);
            stream.close();
        }
        catch (FileNotFoundException e) {
            TerrainControl.log(LogMarker.WARN, "NBT file {} not found", path);
            BO3Loader.tryToClose(stream);
            return null;
        }
        catch (IOException e) {
            BO3Loader.tryToClose(stream);
            try {
                stream = new FileInputStream(path);
                metadata = NamedBinaryTag.readFrom(stream, false);
                stream.close();
            }
            catch (IOException corruptFile) {
                TerrainControl.log(LogMarker.FATAL, "Failed to read NBT meta file: ", e.getMessage());
                TerrainControl.printStackTrace(LogMarker.FATAL, corruptFile);
                BO3Loader.tryToClose(stream);
                return null;
            }
        }
        for (NamedBinaryTag subTag : values = (NamedBinaryTag[])metadata.getValue()) {
            if (subTag.getName() == null || !subTag.getName().equals("id") || !subTag.getType().equals((Object)NamedBinaryTag.Type.TAG_String)) continue;
            return metadata;
        }
        try {
            return BO3Loader.registerMetadata(path, ((NamedBinaryTag[])metadata.getValue())[0]);
        }
        catch (Exception e) {
            TerrainControl.log(LogMarker.WARN, "Structure of NBT file is incorrect: ", e.getMessage());
            return null;
        }
    }

    public static NamedBinaryTag registerMetadata(String pathOnDisk, NamedBinaryTag metadata) {
        loadedTags.put(pathOnDisk, metadata);
        return metadata;
    }

    private static void tryToClose(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onShutdown() {
        loadedTags.clear();
    }
}

