/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects.bo3;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.customobjects.bo3.BO3Config;
import com.khorn.terraincontrol.customobjects.bo3.BO3Function;
import com.khorn.terraincontrol.customobjects.bo3.BO3Loader;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.util.NamedBinaryTag;
import java.util.List;
import java.util.Random;

public class BlockFunction
extends BO3Function {
    public LocalMaterialData material;
    public int x;
    public int y;
    public int z;
    public boolean hasMetaData;
    public NamedBinaryTag metaDataTag;
    public String metaDataName;

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(4, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        this.material = this.readMaterial(args.get(3));
        if (args.size() == 5) {
            this.metaDataTag = BO3Loader.loadMetadata(args.get(4), ((BO3Config)this.getHolder()).getFile());
            if (this.metaDataTag != null) {
                this.hasMetaData = true;
                this.metaDataName = args.get(4);
            }
        }
    }

    @Override
    public String makeString() {
        String start = "Block(" + this.x + ',' + this.y + ',' + this.z + ',' + this.material;
        if (this.hasMetaData) {
            start = start + ',' + this.metaDataName;
        }
        return start + ')';
    }

    @Override
    public BlockFunction rotate() {
        BlockFunction rotatedBlock = new BlockFunction();
        rotatedBlock.x = this.z;
        rotatedBlock.y = this.y;
        rotatedBlock.z = -this.x;
        rotatedBlock.material = this.material.rotate();
        rotatedBlock.hasMetaData = this.hasMetaData;
        rotatedBlock.metaDataTag = this.metaDataTag;
        rotatedBlock.metaDataName = this.metaDataName;
        return rotatedBlock;
    }

    public void spawn(LocalWorld world, Random random, int x, int y, int z) {
        world.setBlock(x, y, z, this.material);
        if (this.hasMetaData) {
            world.attachMetadata(x, y, z, this.metaDataTag);
        }
    }

    @Override
    public boolean isAnalogousTo(ConfigFunction<BO3Config> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        BlockFunction block = (BlockFunction)other;
        return block.x == this.x && block.y == this.y && block.z == this.z;
    }
}

