/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects.bo3;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.customobjects.Branch;
import com.khorn.terraincontrol.customobjects.CustomObjectCoordinate;
import com.khorn.terraincontrol.customobjects.bo3.BranchFunction;
import com.khorn.terraincontrol.customobjects.bo3.BranchNode;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.logging.LogMarker;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public class WeightedBranchFunction
extends BranchFunction
implements Branch {
    public double cumulativeChance = 0.0;

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.branches = new TreeSet();
        this.cumulativeChance = this.readArgs(args, true);
    }

    @Override
    public CustomObjectCoordinate toCustomObjectCoordinate(LocalWorld world, Random random, int x, int y, int z) {
        double randomChance = random.nextDouble() * (this.totalChance != -1.0 ? this.totalChance : (this.cumulativeChance >= 100.0 ? this.cumulativeChance : 100.0));
        TerrainControl.log(LogMarker.TRACE, "W-Branch: chance_max - {}", randomChance);
        for (BranchNode branch : this.branches) {
            TerrainControl.log(LogMarker.TRACE, "  {} trying to spawn! #{}", branch.getCustomObject().getName(), branch.getChance());
            if (!(branch.getChance() >= randomChance)) continue;
            TerrainControl.log(LogMarker.TRACE, "  Successful Spawn", new Object[0]);
            return new CustomObjectCoordinate(branch.getCustomObject(), branch.getRotation(), x + this.x, y + this.y, z + this.z);
        }
        TerrainControl.log(LogMarker.TRACE, "  No Spawn", new Object[0]);
        return null;
    }

    @Override
    protected String getConfigName() {
        return "WeightedBranch";
    }
}

