/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.util.helpers.BlockHelper;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.init.Blocks;

public class ForgeMaterialData
implements LocalMaterialData {
    private static final Map<Block, ForgeMaterialData> CACHE = new IdentityHashMap<Block, ForgeMaterialData>();
    private final Block block;
    private final byte data;

    public static ForgeMaterialData ofIds(int id, int data) {
        return ForgeMaterialData.ofMinecraftBlock(Block.func_149729_e((int)id), data);
    }

    public static ForgeMaterialData ofDefaultMaterial(DefaultMaterial material, int data) {
        return ForgeMaterialData.ofIds(material.id, data);
    }

    public static ForgeMaterialData ofMinecraftBlock(Block block, int data) {
        if (data != 0) {
            return new ForgeMaterialData(block, data);
        }
        ForgeMaterialData cached = CACHE.get(block);
        if (cached != null) {
            return cached;
        }
        ForgeMaterialData newObject = new ForgeMaterialData(block, data);
        CACHE.put(block, newObject);
        return newObject;
    }

    private ForgeMaterialData(Block block, int data) {
        this.block = block;
        this.data = (byte)data;
    }

    @Override
    public boolean canSnowFallOn() {
        return this.toDefaultMaterial().canSnowFallOn();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ForgeMaterialData)) {
            return false;
        }
        ForgeMaterialData other = (ForgeMaterialData)obj;
        if (!this.block.equals(other.block)) {
            return false;
        }
        return this.data == other.data;
    }

    @Override
    public byte getBlockData() {
        return this.data;
    }

    @Override
    public int getBlockId() {
        return Block.func_149682_b((Block)this.block);
    }

    @Override
    public String getName() {
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
            if (this.data != 0) {
                return Block.field_149771_c.func_148750_c((Object)this.block) + ":" + this.data;
            }
            return Block.field_149771_c.func_148750_c((Object)this.block);
        }
        if (this.data != 0) {
            return defaultMaterial.name() + ":" + this.data;
        }
        return defaultMaterial.name();
    }

    @Override
    public int hashCode() {
        return 4096 + this.getBlockId() * 16 + this.data;
    }

    @Override
    public int hashCodeWithoutBlockData() {
        return this.getBlockId();
    }

    @Override
    public boolean isLiquid() {
        return this.block.func_149688_o().func_76224_d();
    }

    @Override
    public boolean isMaterial(DefaultMaterial material) {
        return material.id == this.getBlockId();
    }

    @Override
    public boolean isSolid() {
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != DefaultMaterial.UNKNOWN_BLOCK) {
            return defaultMaterial.isSolid();
        }
        return this.block.func_149688_o().func_76220_a();
    }

    @Override
    public DefaultMaterial toDefaultMaterial() {
        return DefaultMaterial.getMaterial(this.getBlockId());
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public LocalMaterialData withBlockData(int i) {
        if (i == this.data) {
            return this;
        }
        return new ForgeMaterialData(this.block, i);
    }

    public Block internalBlock() {
        return this.block;
    }

    @Override
    public LocalMaterialData rotate() {
        int newData;
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != DefaultMaterial.UNKNOWN_BLOCK && (newData = BlockHelper.rotateData(defaultMaterial, this.data)) != this.data) {
            return new ForgeMaterialData(this.block, newData);
        }
        return this;
    }

    @Override
    public boolean isAir() {
        return this.block == Blocks.field_150350_a;
    }

    @Override
    public boolean canFall() {
        return this.block instanceof BlockFalling;
    }
}

