/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.configuration.WeightedMobSpawnGroup;
import com.khorn.terraincontrol.configuration.standard.MojangSettings;
import com.khorn.terraincontrol.forge.ForgeMaterialData;
import com.khorn.terraincontrol.forge.util.MobSpawnGroupHelper;
import java.util.List;
import net.minecraft.world.biome.BiomeGenBase;

public final class ForgeMojangSettings
implements MojangSettings {
    private final BiomeGenBase biomeBase;

    public static MojangSettings fromId(int biomeId) {
        return ForgeMojangSettings.fromBiomeBase(BiomeGenBase.func_150568_d((int)biomeId));
    }

    public static MojangSettings fromBiomeBase(BiomeGenBase biomeBase) {
        return new ForgeMojangSettings(biomeBase);
    }

    private ForgeMojangSettings(BiomeGenBase biomeBase) {
        this.biomeBase = biomeBase;
    }

    @Override
    public float getTemperature() {
        return this.biomeBase.field_76750_F;
    }

    @Override
    public float getWetness() {
        return this.biomeBase.field_76751_G;
    }

    @Override
    public float getSurfaceHeight() {
        return this.biomeBase.field_76748_D;
    }

    @Override
    public float getSurfaceVolatility() {
        return this.biomeBase.field_76749_E;
    }

    @Override
    public LocalMaterialData getSurfaceBlock() {
        return ForgeMaterialData.ofMinecraftBlock(this.biomeBase.field_76752_A, 0);
    }

    @Override
    public LocalMaterialData getGroundBlock() {
        return ForgeMaterialData.ofMinecraftBlock(this.biomeBase.field_76753_B, 0);
    }

    @Override
    public List<WeightedMobSpawnGroup> getMobSpawnGroup(MojangSettings.EntityCategory entityCategory) {
        return MobSpawnGroupHelper.getListFromMinecraftBiome(this.biomeBase, entityCategory);
    }
}

