/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge;

import com.khorn.terraincontrol.BiomeIds;
import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.BiomeLoadInstruction;
import com.khorn.terraincontrol.configuration.ConfigProvider;
import com.khorn.terraincontrol.configuration.WorldSettings;
import com.khorn.terraincontrol.customobjects.CustomObjectStructureCache;
import com.khorn.terraincontrol.exception.BiomeNotFoundException;
import com.khorn.terraincontrol.forge.ForgeBiome;
import com.khorn.terraincontrol.forge.ForgeMaterialData;
import com.khorn.terraincontrol.forge.ForgeMojangSettings;
import com.khorn.terraincontrol.forge.generator.ChunkProvider;
import com.khorn.terraincontrol.forge.generator.structure.MineshaftGen;
import com.khorn.terraincontrol.forge.generator.structure.NetherFortressGen;
import com.khorn.terraincontrol.forge.generator.structure.RareBuildingGen;
import com.khorn.terraincontrol.forge.generator.structure.StrongholdGen;
import com.khorn.terraincontrol.forge.generator.structure.VillageGen;
import com.khorn.terraincontrol.forge.util.NBTHelper;
import com.khorn.terraincontrol.generator.biome.BiomeGenerator;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.NamedBinaryTag;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultBiome;
import com.khorn.terraincontrol.util.minecraftTypes.TreeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;

public class ForgeWorld
implements LocalWorld {
    private ChunkProvider generator;
    private World world;
    private WorldSettings settings;
    private CustomObjectStructureCache structureCache;
    private String name;
    private long seed;
    private BiomeGenerator biomeGenerator;
    private static int nextBiomeId = 0;
    private static final int MAX_BIOMES_COUNT = 1024;
    private static final int MAX_SAVED_BIOMES_COUNT = 255;
    private static final int STANDARD_WORLD_HEIGHT = 128;
    private static BiomeGenBase[] biomesToRestore = new BiomeGenBase[BiomeGenBase.func_150565_n().length];
    private HashMap<String, LocalBiome> biomeNames = new HashMap();
    public StrongholdGen strongholdGen;
    public VillageGen villageGen;
    public MineshaftGen mineshaftGen;
    public RareBuildingGen rareBuildingGen;
    public NetherFortressGen netherFortressGen;
    private WorldGenDungeons dungeonGen;
    private WorldGenTrees tree;
    private WorldGenSavannaTree acaciaTree;
    private WorldGenBigTree bigTree;
    private WorldGenForest birchTree;
    private WorldGenTrees cocoaTree;
    private WorldGenCanopyTree darkOakTree;
    private WorldGenShrub groundBush;
    private WorldGenBigMushroom hugeMushroom;
    private WorldGenMegaPineTree hugeTaigaTree1;
    private WorldGenMegaPineTree hugeTaigaTree2;
    private WorldGenMegaJungle jungleTree;
    private WorldGenForest longBirchTree;
    private WorldGenSwamp swampTree;
    private WorldGenTaiga1 taigaTree1;
    private WorldGenTaiga2 taigaTree2;
    private Chunk[] chunkCache;

    public static void restoreBiomes() {
        BiomeGenBase[] biomeList = BiomeGenBase.func_150565_n();
        for (BiomeGenBase oldBiome : biomesToRestore) {
            if (oldBiome == null) continue;
            biomeList[oldBiome.field_76756_M] = oldBiome;
        }
        nextBiomeId = 0;
    }

    public ForgeWorld(String _name) {
        this.name = _name;
        for (DefaultBiome defaultBiome : DefaultBiome.values()) {
            BiomeGenBase oldBiome;
            int biomeId = defaultBiome.Id;
            ForgeWorld.biomesToRestore[biomeId] = oldBiome = BiomeGenBase.func_150568_d((int)biomeId);
            ++nextBiomeId;
        }
    }

    @Override
    public LocalBiome createBiomeFor(BiomeConfig biomeConfig, BiomeIds biomeIds) {
        ForgeBiome biome = ForgeBiome.createBiome(biomeConfig, biomeIds);
        this.biomeNames.put(biome.getName(), biome);
        return biome;
    }

    @Override
    public int getMaxBiomesCount() {
        return 1024;
    }

    @Override
    public int getMaxSavedBiomesCount() {
        return 255;
    }

    @Override
    public int getFreeBiomeId() {
        return nextBiomeId++;
    }

    @Override
    public ForgeBiome getBiomeById(int id) throws BiomeNotFoundException {
        LocalBiome biome = this.settings.biomes[id];
        if (biome == null) {
            throw new BiomeNotFoundException(id, Arrays.asList(this.settings.biomes));
        }
        return (ForgeBiome)biome;
    }

    @Override
    public LocalBiome getBiomeByIdOrNull(int id) {
        return this.settings.biomes[id];
    }

    @Override
    public LocalBiome getBiomeByName(String name) throws BiomeNotFoundException {
        LocalBiome biome = this.biomeNames.get(name);
        if (biome == null) {
            throw new BiomeNotFoundException(name, this.biomeNames.keySet());
        }
        return biome;
    }

    public Collection<BiomeLoadInstruction> getDefaultBiomes() {
        ArrayList<BiomeLoadInstruction> standardBiomes = new ArrayList<BiomeLoadInstruction>();
        for (DefaultBiome defaultBiome : DefaultBiome.values()) {
            int id = defaultBiome.Id;
            BiomeLoadInstruction instruction = defaultBiome.getLoadInstructions(ForgeMojangSettings.fromId(id), 128);
            standardBiomes.add(instruction);
        }
        return standardBiomes;
    }

    @Override
    public void prepareDefaultStructures(int chunkX, int chunkZ, boolean dry) {
        if (this.settings.worldConfig.strongholdsEnabled) {
            this.strongholdGen.func_151539_a(null, this.world, chunkX, chunkZ, null);
        }
        if (this.settings.worldConfig.mineshaftsEnabled) {
            this.mineshaftGen.func_151539_a(null, this.world, chunkX, chunkZ, null);
        }
        if (this.settings.worldConfig.villagesEnabled && dry) {
            this.villageGen.func_151539_a(null, this.world, chunkX, chunkZ, null);
        }
        if (this.settings.worldConfig.rareBuildingsEnabled) {
            this.rareBuildingGen.func_151539_a(null, this.world, chunkX, chunkZ, null);
        }
        if (this.settings.worldConfig.netherFortressesEnabled) {
            this.netherFortressGen.func_151539_a(null, this.world, chunkX, chunkZ, null);
        }
    }

    @Override
    public void PlaceDungeons(Random rand, int x, int y, int z) {
        this.dungeonGen.func_76484_a(this.world, rand, x, y, z);
    }

    @Override
    public boolean PlaceTree(TreeType type, Random rand, int x, int y, int z) {
        switch (type) {
            case Tree: {
                return this.tree.func_76484_a(this.world, rand, x, y, z);
            }
            case BigTree: {
                this.bigTree.func_76487_a(1.0, 1.0, 1.0);
                return this.bigTree.func_76484_a(this.world, rand, x, y, z);
            }
            case Forest: 
            case Birch: {
                return this.birchTree.func_76484_a(this.world, rand, x, y, z);
            }
            case TallBirch: {
                return this.longBirchTree.func_76484_a(this.world, rand, x, y, z);
            }
            case HugeMushroom: {
                this.hugeMushroom.func_76487_a(1.0, 1.0, 1.0);
                return this.hugeMushroom.func_76484_a(this.world, rand, x, y, z);
            }
            case SwampTree: {
                return this.swampTree.func_76484_a(this.world, rand, x, y, z);
            }
            case Taiga1: {
                return this.taigaTree1.func_76484_a(this.world, rand, x, y, z);
            }
            case Taiga2: {
                return this.taigaTree2.func_76484_a(this.world, rand, x, y, z);
            }
            case JungleTree: {
                return this.jungleTree.func_76484_a(this.world, rand, x, y, z);
            }
            case GroundBush: {
                return this.groundBush.func_76484_a(this.world, rand, x, y, z);
            }
            case CocoaTree: {
                return this.cocoaTree.func_76484_a(this.world, rand, x, y, z);
            }
            case Acacia: {
                return this.acaciaTree.func_76484_a(this.world, rand, x, y, z);
            }
            case DarkOak: {
                return this.darkOakTree.func_76484_a(this.world, rand, x, y, z);
            }
            case HugeTaiga1: {
                return this.hugeTaigaTree1.func_76484_a(this.world, rand, x, y, z);
            }
            case HugeTaiga2: {
                return this.hugeTaigaTree2.func_76484_a(this.world, rand, x, y, z);
            }
        }
        throw new AssertionError((Object)("Failed to handle tree of type " + type.toString()));
    }

    @Override
    public boolean placeDefaultStructures(Random rand, ChunkCoordinate chunkCoord) {
        int chunkX = chunkCoord.getChunkX();
        int chunkZ = chunkCoord.getChunkZ();
        boolean isVillagePlaced = false;
        if (this.settings.worldConfig.strongholdsEnabled) {
            this.strongholdGen.func_75051_a(this.world, rand, chunkX, chunkZ);
        }
        if (this.settings.worldConfig.mineshaftsEnabled) {
            this.mineshaftGen.func_75051_a(this.world, rand, chunkX, chunkZ);
        }
        if (this.settings.worldConfig.villagesEnabled) {
            isVillagePlaced = this.villageGen.func_75051_a(this.world, rand, chunkX, chunkZ);
        }
        if (this.settings.worldConfig.rareBuildingsEnabled) {
            this.rareBuildingGen.func_75051_a(this.world, rand, chunkX, chunkZ);
        }
        if (this.settings.worldConfig.netherFortressesEnabled) {
            this.netherFortressGen.func_75051_a(this.world, rand, chunkX, chunkZ);
        }
        return isVillagePlaced;
    }

    @Override
    public void replaceBlocks(ChunkCoordinate chunkCoord) {
        if (!this.settings.worldConfig.BiomeConfigsHaveReplacement) {
            return;
        }
        Chunk[] cache = this.getChunkCache(chunkCoord);
        this.replaceBlocks(cache[0], 8, 8);
        this.replaceBlocks(cache[1], 0, 8);
        this.replaceBlocks(cache[2], 8, 0);
        this.replaceBlocks(cache[3], 0, 0);
    }

    private void replaceBlocks(Chunk rawChunk, int startXInChunk, int startZInChunk) {
        ExtendedBlockStorage[] sectionsArray;
        int endXInChunk = startXInChunk + 8;
        int endZInChunk = startZInChunk + 8;
        int worldStartX = rawChunk.field_76635_g * 16;
        int worldStartZ = rawChunk.field_76647_h * 16;
        for (ExtendedBlockStorage section : sectionsArray = rawChunk.func_76587_i()) {
            if (section == null) continue;
            for (int sectionX = startXInChunk; sectionX < endXInChunk; ++sectionX) {
                block2: for (int sectionZ = startZInChunk; sectionZ < endZInChunk; ++sectionZ) {
                    LocalBiome biome = this.getBiome(worldStartX + sectionX, worldStartZ + sectionZ);
                    if (biome == null || !biome.getBiomeConfig().replacedBlocks.hasReplaceSettings()) continue;
                    LocalMaterialData[][] replaceArray = biome.getBiomeConfig().replacedBlocks.compiledInstructions;
                    for (int sectionY = 0; sectionY < 16; ++sectionY) {
                        Block block = section.func_150819_a(sectionX, sectionY, sectionZ);
                        int blockId = Block.func_149682_b((Block)block);
                        if (replaceArray[blockId] == null) continue;
                        int y = section.func_76662_d() + sectionY;
                        if (y >= replaceArray[blockId].length) continue block2;
                        ForgeMaterialData replaceTo = (ForgeMaterialData)replaceArray[blockId][y];
                        if (replaceTo == null || replaceTo.getBlockId() == blockId) continue;
                        section.func_150818_a(sectionX, sectionY, sectionZ, replaceTo.internalBlock());
                        section.func_76654_b(sectionX, sectionY, sectionZ, (int)replaceTo.getBlockData());
                    }
                }
            }
        }
    }

    @Override
    public void placePopulationMobs(LocalBiome biome, Random random, ChunkCoordinate chunkCoord) {
        SpawnerAnimals.func_77191_a((World)this.getWorld(), (BiomeGenBase)((ForgeBiome)biome).getHandle(), (int)chunkCoord.getBlockXCenter(), (int)chunkCoord.getBlockZCenter(), (int)16, (int)16, (Random)random);
    }

    private Chunk getChunk(int x, int y, int z) {
        if (y < 0 || y >= 256) {
            return null;
        }
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        if (this.chunkCache == null) {
            return this.world.func_72964_e(chunkX, chunkZ);
        }
        Chunk topLeftCachedChunk = this.chunkCache[0];
        int indexX = chunkX - topLeftCachedChunk.field_76635_g;
        int indexZ = chunkZ - topLeftCachedChunk.field_76647_h;
        if (!(indexX != 0 && indexX != 1 || indexZ != 0 && indexZ != 1)) {
            return this.chunkCache[indexX | indexZ << 1];
        }
        if (this.settings.worldConfig.populationBoundsCheck) {
            return null;
        }
        if (this.world.func_72863_F().func_73149_a(chunkX, chunkZ)) {
            return this.world.func_72964_e(chunkX, chunkZ);
        }
        return null;
    }

    @Override
    public int getLiquidHeight(int x, int z) {
        for (int y = this.getHighestBlockYAt(x, z) - 1; y > 0; --y) {
            LocalMaterialData material = this.getMaterial(x, y, z);
            if (material.isLiquid()) {
                return y + 1;
            }
            if (!material.isSolid()) continue;
            return -1;
        }
        return -1;
    }

    @Override
    public int getSolidHeight(int x, int z) {
        for (int y = this.getHighestBlockYAt(x, z) - 1; y > 0; --y) {
            LocalMaterialData material = this.getMaterial(x, y, z);
            if (!material.isSolid()) continue;
            return y + 1;
        }
        return -1;
    }

    @Override
    public boolean isEmpty(int x, int y, int z) {
        Chunk chunk = this.getChunk(x, y, z);
        if (chunk == null) {
            return true;
        }
        return chunk.func_150810_a(x & 0xF, y, z & 0xF).func_149688_o().equals(Material.field_151579_a);
    }

    @Override
    public LocalMaterialData getMaterial(int x, int y, int z) {
        Chunk chunk = this.getChunk(x, y, z);
        if (chunk == null) {
            return ForgeMaterialData.ofMinecraftBlock(Blocks.field_150350_a, 0);
        }
        return ForgeMaterialData.ofMinecraftBlock(chunk.func_150810_a(x &= 0xF, y, z &= 0xF), chunk.func_76628_c(x, y, z));
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material) {
        if (y < 0 || y >= 256) {
            return;
        }
        Chunk chunk = this.getChunk(x, y, z);
        if (chunk == null) {
            return;
        }
        boolean oldStatic = this.world.field_72995_K;
        this.world.field_72995_K = true;
        chunk.func_150807_a(x & 0xF, y, z & 0xF, ((ForgeMaterialData)material).internalBlock(), (int)material.getBlockData());
        this.world.field_72995_K = oldStatic;
        this.world.func_147451_t(x, y, z);
        if (!this.world.field_72995_K) {
            this.world.func_147471_g(x, y, z);
        }
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        int y;
        Chunk chunk = this.getChunk(x, 0, z);
        if (chunk == null) {
            return -1;
        }
        int maxSearchY = y + 5;
        for (y = chunk.func_76611_b(x &= 0xF, z &= 0xF); chunk.func_150810_a(x, y, z) != Blocks.field_150350_a && y <= maxSearchY; ++y) {
        }
        return y;
    }

    @Override
    public void startPopulation(ChunkCoordinate chunkCoord) {
        if (this.chunkCache != null && this.settings.worldConfig.populationBoundsCheck) {
            throw new IllegalStateException("Chunk is already being populated. This may be a bug in Terrain Control, but it may also be another mod that is poking in unloaded chunks. Set PopulationBoundsCheck to false in the WorldConfig to disable this error.");
        }
        this.chunkCache = this.loadFourChunks(chunkCoord);
    }

    private Chunk[] getChunkCache(ChunkCoordinate topLeft) {
        if (this.chunkCache == null || !topLeft.coordsMatch(this.chunkCache[0].field_76635_g, this.chunkCache[0].field_76647_h)) {
            if (this.settings.worldConfig.populationBoundsCheck) {
                throw new IllegalStateException("chunkCache is null");
            }
            return this.loadFourChunks(topLeft);
        }
        return this.chunkCache;
    }

    private Chunk[] loadFourChunks(ChunkCoordinate topLeft) {
        Chunk[] chunkCache = new Chunk[4];
        for (int indexX = 0; indexX <= 1; ++indexX) {
            for (int indexZ = 0; indexZ <= 1; ++indexZ) {
                chunkCache[indexX | indexZ << 1] = this.world.func_72964_e(topLeft.getChunkX() + indexX, topLeft.getChunkZ() + indexZ);
            }
        }
        return chunkCache;
    }

    @Override
    public void endPopulation() {
        if (this.chunkCache == null && this.settings.worldConfig.populationBoundsCheck) {
            throw new IllegalStateException("Chunk is not being populated. This may be a bug in Terrain Control, but it may also be another mod that is poking in unloaded chunks. Set PopulationBoundsCheck to false in the WorldConfig to disable this error.");
        }
        this.chunkCache = null;
    }

    @Override
    public int getLightLevel(int x, int y, int z) {
        return this.world.func_72883_k(x, y, z);
    }

    @Override
    public boolean isLoaded(int x, int y, int z) {
        return this.getChunk(x, y, z) != null;
    }

    @Override
    @Deprecated
    public WorldSettings getSettings() {
        return this.settings;
    }

    @Override
    public ConfigProvider getConfigs() {
        return this.settings;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public int getHeightCap() {
        return this.settings.worldConfig.worldHeightCap;
    }

    @Override
    public int getHeightScale() {
        return this.settings.worldConfig.worldHeightScale;
    }

    public ChunkProvider getChunkGenerator() {
        return this.generator;
    }

    public void InitM(World world, WorldSettings config) {
        this.settings = config;
        this.world = world;
        this.seed = world.func_72905_C();
    }

    public void Init(World world, WorldSettings configs) {
        this.settings = configs;
        this.world = world;
        this.seed = world.func_72905_C();
        this.structureCache = new CustomObjectStructureCache(this);
        this.dungeonGen = new WorldGenDungeons();
        this.strongholdGen = new StrongholdGen(configs);
        this.villageGen = new VillageGen(configs);
        this.mineshaftGen = new MineshaftGen();
        this.rareBuildingGen = new RareBuildingGen(configs);
        this.netherFortressGen = new NetherFortressGen();
        this.tree = new WorldGenTrees(false);
        this.acaciaTree = new WorldGenSavannaTree(false);
        this.cocoaTree = new WorldGenTrees(false, 5, 3, 3, true);
        this.bigTree = new WorldGenBigTree(false);
        this.birchTree = new WorldGenForest(false, false);
        this.darkOakTree = new WorldGenCanopyTree(false);
        this.longBirchTree = new WorldGenForest(false, true);
        this.swampTree = new WorldGenSwamp();
        this.taigaTree1 = new WorldGenTaiga1();
        this.taigaTree2 = new WorldGenTaiga2(false);
        this.hugeMushroom = new WorldGenBigMushroom();
        this.hugeTaigaTree1 = new WorldGenMegaPineTree(false, false);
        this.hugeTaigaTree2 = new WorldGenMegaPineTree(false, true);
        this.jungleTree = new WorldGenMegaJungle(false, 10, 20, 3, 3);
        this.groundBush = new WorldGenShrub(3, 0);
        this.generator = new ChunkProvider(this);
    }

    public void setBiomeManager(BiomeGenerator manager) {
        this.biomeGenerator = manager;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public LocalBiome getCalculatedBiome(int x, int z) {
        return this.getBiomeById(this.biomeGenerator.getBiome(x, z));
    }

    @Override
    public LocalBiome getBiome(int x, int z) {
        if (this.settings.worldConfig.populateUsingSavedBiomes) {
            return this.getSavedBiome(x, z);
        }
        return this.getCalculatedBiome(x, z);
    }

    @Override
    public LocalBiome getSavedBiome(int x, int z) throws BiomeNotFoundException {
        return this.getBiomeById(this.world.func_72807_a((int)x, (int)z).field_76756_M);
    }

    @Override
    public void attachMetadata(int x, int y, int z, NamedBinaryTag tag) {
        NBTTagCompound nmsTag = NBTHelper.getNMSFromNBTTagCompound(tag);
        nmsTag.func_74768_a("x", x);
        nmsTag.func_74768_a("y", y);
        nmsTag.func_74768_a("z", z);
        TileEntity tileEntity = this.world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            tileEntity.func_145839_a(nmsTag);
        } else {
            TerrainControl.log(LogMarker.DEBUG, "Skipping tile entity with id {}, cannot be placed at {},{},{} on id {}", nmsTag.func_74779_i("id"), x, y, z, this.getMaterial(x, y, z));
        }
    }

    @Override
    public NamedBinaryTag getMetadata(int x, int y, int z) {
        TileEntity tileEntity = this.world.func_147438_o(x, y, z);
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound nmsTag = new NBTTagCompound();
        tileEntity.func_145841_b(nmsTag);
        nmsTag.func_82580_o("x");
        nmsTag.func_82580_o("y");
        nmsTag.func_82580_o("z");
        return NBTHelper.getNBTFromNMSTagCompound(null, nmsTag);
    }

    @Override
    public CustomObjectStructureCache getStructureCache() {
        return this.structureCache;
    }

    @Override
    public BiomeGenerator getBiomeGenerator() {
        return this.biomeGenerator;
    }

    public static BiomeGenBase[] getOriginalBiomes() {
        return biomesToRestore;
    }
}

