/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.events.EventPriority;
import com.khorn.terraincontrol.forge.ForgeEngine;
import com.khorn.terraincontrol.forge.MooshroomSpawnHandler;
import com.khorn.terraincontrol.forge.TCWorldType;
import com.khorn.terraincontrol.forge.commands.GetSpawnsCommand;
import com.khorn.terraincontrol.forge.events.EventManager;
import com.khorn.terraincontrol.forge.events.PacketHandler;
import com.khorn.terraincontrol.forge.events.PlayerTracker;
import com.khorn.terraincontrol.forge.events.SaplingListener;
import com.khorn.terraincontrol.forge.generator.ForgeVanillaBiomeGenerator;
import com.khorn.terraincontrol.forge.generator.structure.RareBuildingStart;
import com.khorn.terraincontrol.forge.generator.structure.VillageStart;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="TerrainControl", name="TerrainControl", acceptableRemoteVersions="*")
public class TCPlugin {
    @Mod.Instance(value="TerrainControl")
    public static TCPlugin instance;
    public File terrainControlDirectory;

    @Mod.EventHandler
    public static void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new GetSpawnsCommand());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MooshroomSpawnHandler handler = new MooshroomSpawnHandler();
        TerrainControl.setEngine(new ForgeEngine(new TCWorldType("TerrainControl")));
        TerrainControl.getBiomeModeManager().register("Default", ForgeVanillaBiomeGenerator.class);
        MapGenStructureIO.func_143034_b(RareBuildingStart.class, (String)"TCTemple");
        MapGenStructureIO.func_143034_b(VillageStart.class, (String)"TCVillage");
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            FMLEventChannel eventDrivenChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel("TerrainControl");
            eventDrivenChannel.register((Object)new PacketHandler());
        }
        FMLCommonHandler.instance().bus().register((Object)new PlayerTracker());
        SaplingListener saplingListener = new SaplingListener();
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)saplingListener);
        MinecraftForge.EVENT_BUS.register((Object)saplingListener);
        TerrainControl.registerEventHandler(new EventManager(), EventPriority.CANCELABLE);
    }
}

