/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.configuration.WorldSettings;
import com.khorn.terraincontrol.forge.ForgeWorld;
import com.khorn.terraincontrol.forge.generator.ForgeVanillaBiomeGenerator;
import com.khorn.terraincontrol.forge.generator.TCWorldChunkManager;
import com.khorn.terraincontrol.forge.util.WorldHelper;
import com.khorn.terraincontrol.generator.biome.BiomeGenerator;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;

public class TCWorldType
extends WorldType {
    public ForgeWorld worldTC;

    public TCWorldType(String paramString) {
        super(paramString);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_151357_h() {
        return true;
    }

    public WorldChunkManager getChunkManager(World world) {
        try {
            if (world instanceof WorldClient) {
                return super.getChunkManager(world);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        ForgeWorld.restoreBiomes();
        File worldDirectory = new File(world.func_72860_G().func_75765_b(), "TerrainControl");
        if (!worldDirectory.exists()) {
            System.out.println("TerrainControl: settings does not exist, creating defaults");
            if (!worldDirectory.mkdirs()) {
                System.out.println("TerrainControl: cant create folder " + worldDirectory.getAbsolutePath());
            }
        }
        this.worldTC = new ForgeWorld(world.func_72860_G().func_75760_g());
        WorldSettings config = new WorldSettings(worldDirectory, this.worldTC, false);
        this.worldTC.Init(world, config);
        Class<? extends BiomeGenerator> biomeGenClass = this.worldTC.getConfigs().getWorldConfig().biomeMode;
        BiomeGenerator biomeManager = TerrainControl.getBiomeModeManager().createCached(biomeGenClass, this.worldTC);
        WorldChunkManager chunkManager = this.createWorldChunkManager(this.worldTC, biomeManager);
        this.worldTC.setBiomeManager(biomeManager);
        return chunkManager;
    }

    private WorldChunkManager createWorldChunkManager(ForgeWorld world, BiomeGenerator biomeGenerator) {
        if (biomeGenerator instanceof ForgeVanillaBiomeGenerator) {
            WorldChunkManager worldChunkManager = super.getChunkManager(world.getWorld());
            ((ForgeVanillaBiomeGenerator)biomeGenerator).setWorldChunkManager(worldChunkManager);
            return worldChunkManager;
        }
        return new TCWorldChunkManager(this.worldTC, biomeGenerator);
    }

    public IChunkProvider getChunkGenerator(World world, String generatorOptions) {
        if (this.worldTC.getConfigs().getWorldConfig().ModeTerrain != WorldConfig.TerrainMode.Default) {
            return this.worldTC.getChunkGenerator();
        }
        return super.getChunkGenerator(world, generatorOptions);
    }

    public int getMinimumSpawnHeight(World mcWorld) {
        LocalWorld world = WorldHelper.toLocalWorld(mcWorld);
        if (world == null) {
            return 64;
        }
        return world.getConfigs().getWorldConfig().waterLevelMax;
    }
}

