/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.events;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.events.EventHandler;
import com.khorn.terraincontrol.forge.ForgeWorld;
import com.khorn.terraincontrol.generator.resource.CustomObjectGen;
import com.khorn.terraincontrol.generator.resource.DungeonGen;
import com.khorn.terraincontrol.generator.resource.LiquidGen;
import com.khorn.terraincontrol.generator.resource.OreGen;
import com.khorn.terraincontrol.generator.resource.Resource;
import com.khorn.terraincontrol.generator.resource.SmallLakeGen;
import com.khorn.terraincontrol.generator.resource.UndergroundLakeGen;
import com.khorn.terraincontrol.generator.resource.VeinGen;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class EventManager
extends EventHandler {
    private Map<String, Boolean> hasOreGenBegun = new HashMap<String, Boolean>();
    private Map<String, Boolean> hasDecorationBegun = new HashMap<String, Boolean>();

    @Override
    public boolean onResourceProcess(Resource resource, LocalWorld localWorld, Random random, boolean villageInChunk, int chunkX, int chunkZ, boolean isCancelled) {
        ForgeWorld world = (ForgeWorld)localWorld;
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        if (resource instanceof DungeonGen || resource instanceof SmallLakeGen || resource instanceof UndergroundLakeGen || resource instanceof LiquidGen || resource instanceof CustomObjectGen) {
            PopulateChunkEvent.Populate.EventType forgeEvent = this.getPopulateEventType(resource.getMaterial());
            return TerrainGen.populate((IChunkProvider)world.getChunkGenerator(), (World)world.getWorld(), (Random)random, (int)blockX, (int)blockZ, (boolean)villageInChunk, (PopulateChunkEvent.Populate.EventType)forgeEvent);
        }
        if (resource instanceof OreGen || resource instanceof VeinGen) {
            if (!this.hasOreGenerationBegun(world)) {
                MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(world.getWorld(), random, blockX, blockZ));
                this.setOreGenerationBegun(world, true);
            }
            OreGenEvent.GenerateMinable.EventType forgeEvent = this.getOreEventType(resource.getMaterial());
            return TerrainGen.generateOre((World)world.getWorld(), (Random)random, null, (int)blockX, (int)blockZ, (OreGenEvent.GenerateMinable.EventType)forgeEvent);
        }
        if (!this.hasDecorationBegun(world)) {
            MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(world.getWorld(), random, blockX, chunkZ * 16));
            this.setDecorationBegun(world, true);
        }
        DecorateBiomeEvent.Decorate.EventType forgeEvent = this.getDecorateEventType(resource.getMaterial());
        return TerrainGen.decorate((World)world.getWorld(), (Random)random, (int)blockX, (int)blockZ, (DecorateBiomeEvent.Decorate.EventType)forgeEvent);
    }

    @Override
    public void onPopulateStart(LocalWorld localWorld, Random random, boolean villageInChunk, int chunkX, int chunkZ) {
        ForgeWorld world = (ForgeWorld)localWorld;
        this.setDecorationBegun(world, false);
        this.setOreGenerationBegun(world, false);
        PopulateChunkEvent.Pre forgeEvent = new PopulateChunkEvent.Pre((IChunkProvider)world.getChunkGenerator(), world.getWorld(), random, chunkX * 16, chunkZ * 16, villageInChunk);
        MinecraftForge.EVENT_BUS.post((Event)forgeEvent);
    }

    @Override
    public void onPopulateEnd(LocalWorld localWorld, Random random, boolean villageInChunk, int chunkX, int chunkZ) {
        ForgeWorld world = (ForgeWorld)localWorld;
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        if (this.hasDecorationBegun(world)) {
            MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(world.getWorld(), random, blockX, blockZ));
            this.setDecorationBegun(world, false);
        }
        if (this.hasOreGenerationBegun(world)) {
            MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(world.getWorld(), random, blockX, blockZ));
            this.setOreGenerationBegun(world, false);
        }
        PopulateChunkEvent.Post forgeEvent = new PopulateChunkEvent.Post((IChunkProvider)world.getChunkGenerator(), world.getWorld(), random, blockX, blockZ, villageInChunk);
        MinecraftForge.EVENT_BUS.post((Event)forgeEvent);
    }

    private DecorateBiomeEvent.Decorate.EventType getDecorateEventType(LocalMaterialData block) {
        if (block == null) {
            return DecorateBiomeEvent.Decorate.EventType.CUSTOM;
        }
        if (block.isMaterial(DefaultMaterial.WATER_LILY)) {
            return DecorateBiomeEvent.Decorate.EventType.LILYPAD;
        }
        if (block.isMaterial(DefaultMaterial.CACTUS)) {
            return DecorateBiomeEvent.Decorate.EventType.CACTUS;
        }
        if (block.isMaterial(DefaultMaterial.LONG_GRASS)) {
            return DecorateBiomeEvent.Decorate.EventType.GRASS;
        }
        if (block.isMaterial(DefaultMaterial.DEAD_BUSH)) {
            return DecorateBiomeEvent.Decorate.EventType.DEAD_BUSH;
        }
        if (block.isMaterial(DefaultMaterial.RED_ROSE) || block.isMaterial(DefaultMaterial.YELLOW_FLOWER) || block.isMaterial(DefaultMaterial.DOUBLE_PLANT)) {
            return DecorateBiomeEvent.Decorate.EventType.FLOWERS;
        }
        if (block.isMaterial(DefaultMaterial.PUMPKIN)) {
            return DecorateBiomeEvent.Decorate.EventType.PUMPKIN;
        }
        if (block.isMaterial(DefaultMaterial.BROWN_MUSHROOM) || block.isMaterial(DefaultMaterial.RED_MUSHROOM)) {
            return DecorateBiomeEvent.Decorate.EventType.SHROOM;
        }
        if (block.isMaterial(DefaultMaterial.SUGAR_CANE_BLOCK)) {
            return DecorateBiomeEvent.Decorate.EventType.REED;
        }
        if (block.isMaterial(DefaultMaterial.SAND)) {
            return DecorateBiomeEvent.Decorate.EventType.SAND;
        }
        if (block.isMaterial(DefaultMaterial.CLAY)) {
            return DecorateBiomeEvent.Decorate.EventType.CLAY;
        }
        return DecorateBiomeEvent.Decorate.EventType.CUSTOM;
    }

    private PopulateChunkEvent.Populate.EventType getPopulateEventType(LocalMaterialData block) {
        if (block == null) {
            return PopulateChunkEvent.Populate.EventType.CUSTOM;
        }
        if (block.isMaterial(DefaultMaterial.WATER) || block.isMaterial(DefaultMaterial.STATIONARY_WATER)) {
            return PopulateChunkEvent.Populate.EventType.LAKE;
        }
        if (block.isMaterial(DefaultMaterial.LAVA) || block.isMaterial(DefaultMaterial.STATIONARY_LAVA)) {
            return PopulateChunkEvent.Populate.EventType.LAVA;
        }
        return PopulateChunkEvent.Populate.EventType.CUSTOM;
    }

    private OreGenEvent.GenerateMinable.EventType getOreEventType(LocalMaterialData block) {
        if (block.isMaterial(DefaultMaterial.COAL_ORE)) {
            return OreGenEvent.GenerateMinable.EventType.COAL;
        }
        if (block.isMaterial(DefaultMaterial.DIAMOND_ORE)) {
            return OreGenEvent.GenerateMinable.EventType.DIAMOND;
        }
        if (block.isMaterial(DefaultMaterial.DIRT)) {
            return OreGenEvent.GenerateMinable.EventType.DIRT;
        }
        if (block.isMaterial(DefaultMaterial.GOLD_ORE)) {
            return OreGenEvent.GenerateMinable.EventType.GOLD;
        }
        if (block.isMaterial(DefaultMaterial.GRAVEL)) {
            return OreGenEvent.GenerateMinable.EventType.GRAVEL;
        }
        if (block.isMaterial(DefaultMaterial.IRON_ORE)) {
            return OreGenEvent.GenerateMinable.EventType.IRON;
        }
        if (block.isMaterial(DefaultMaterial.LAPIS_ORE)) {
            return OreGenEvent.GenerateMinable.EventType.LAPIS;
        }
        if (block.isMaterial(DefaultMaterial.REDSTONE_ORE)) {
            return OreGenEvent.GenerateMinable.EventType.REDSTONE;
        }
        return OreGenEvent.GenerateMinable.EventType.CUSTOM;
    }

    private boolean hasOreGenerationBegun(LocalWorld world) {
        return this.hasOreGenBegun.get(world.getName());
    }

    private boolean hasDecorationBegun(LocalWorld world) {
        return this.hasDecorationBegun.get(world.getName());
    }

    private void setOreGenerationBegun(LocalWorld world, boolean begun) {
        this.hasOreGenBegun.put(world.getName(), begun);
    }

    private void setDecorationBegun(LocalWorld world, boolean begun) {
        this.hasDecorationBegun.put(world.getName(), begun);
    }
}

