/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.events;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.exception.BiomeNotFoundException;
import com.khorn.terraincontrol.forge.util.WorldHelper;
import com.khorn.terraincontrol.generator.resource.SaplingGen;
import com.khorn.terraincontrol.generator.resource.SaplingType;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;

public class SaplingListener {
    @SubscribeEvent
    public void onSaplingGrow(SaplingGrowTreeEvent event) {
        World world = event.world;
        LocalWorld localWorld = WorldHelper.toLocalWorld(world);
        if (localWorld == null) {
            return;
        }
        SaplingGrower saplingGrower = new SaplingGrower(localWorld, event.x, event.y, event.z);
        if (saplingGrower.saplingType == null) {
            return;
        }
        SaplingGen saplingGen = this.getSaplingGen(localWorld, saplingGrower.saplingType, saplingGrower.x, saplingGrower.z);
        if (saplingGen == null) {
            return;
        }
        event.setResult(Event.Result.DENY);
        if (saplingGrower.saplingType.requiresFourSaplings()) {
            world.func_147449_b(saplingGrower.x, saplingGrower.y, saplingGrower.z, Blocks.field_150350_a);
            world.func_147449_b(saplingGrower.x + 1, saplingGrower.y, saplingGrower.z, Blocks.field_150350_a);
            world.func_147449_b(saplingGrower.x, saplingGrower.y, saplingGrower.z + 1, Blocks.field_150350_a);
            world.func_147449_b(saplingGrower.x + 1, saplingGrower.y, saplingGrower.z + 1, Blocks.field_150350_a);
        } else {
            world.func_147449_b(saplingGrower.x, saplingGrower.y, saplingGrower.z, Blocks.field_150350_a);
        }
        boolean saplingGrown = false;
        for (int i = 0; i < 10; ++i) {
            if (!saplingGen.growSapling(localWorld, new Random(), saplingGrower.x, saplingGrower.y, saplingGrower.z)) continue;
            saplingGrown = true;
            break;
        }
        if (!saplingGrown) {
            if (saplingGrower.saplingType.requiresFourSaplings()) {
                localWorld.setBlock(saplingGrower.x, saplingGrower.y, saplingGrower.z, saplingGrower.material);
                localWorld.setBlock(saplingGrower.x + 1, saplingGrower.y, saplingGrower.z, saplingGrower.material);
                localWorld.setBlock(saplingGrower.x, saplingGrower.y, saplingGrower.z + 1, saplingGrower.material);
                localWorld.setBlock(saplingGrower.x + 1, saplingGrower.y, saplingGrower.z + 1, saplingGrower.material);
            } else {
                localWorld.setBlock(saplingGrower.x, saplingGrower.y, saplingGrower.z, saplingGrower.material);
            }
        }
    }

    @SubscribeEvent
    public void onBonemealUse(BonemealEvent event) {
        LocalWorld localWorld = WorldHelper.toLocalWorld(event.world);
        if (localWorld == null) {
            return;
        }
        SaplingGen gen = null;
        if (event.block == Blocks.field_150419_aX) {
            gen = this.getSaplingGen(localWorld, SaplingType.RedMushroom, event.x, event.z);
        } else if (event.block == Blocks.field_150420_aW) {
            gen = this.getSaplingGen(localWorld, SaplingType.BrownMushroom, event.x, event.z);
        }
        if (gen == null) {
            return;
        }
        event.setResult(Event.Result.ALLOW);
        event.world.func_147449_b(event.x, event.y, event.z, Blocks.field_150350_a);
        boolean mushroomGrown = false;
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            if (!gen.growSapling(localWorld, random, event.x, event.y, event.z)) continue;
            mushroomGrown = true;
            break;
        }
        if (!mushroomGrown) {
            event.world.func_147465_d(event.x, event.y, event.z, event.block, 0, 3);
        }
    }

    public SaplingGen getSaplingGen(LocalWorld world, SaplingType type, int x, int z) {
        try {
            LocalBiome biome = world.getSavedBiome(x, z);
            TerrainControl.log(LogMarker.INFO, "Biome: {}" + biome.getName(), new Object[0]);
            return biome.getBiomeConfig().getSaplingGen(type);
        }
        catch (BiomeNotFoundException e) {
            return null;
        }
    }

    private static class SaplingGrower {
        private final LocalWorld world;
        private final LocalMaterialData material;
        private final SaplingType saplingType;
        private int x;
        private final int y;
        private int z;

        private SaplingGrower(LocalWorld world, int x, int y, int z) {
            this.world = world;
            this.material = world.getMaterial(x, y, z);
            this.x = x;
            this.y = y;
            this.z = z;
            if (!this.material.isMaterial(DefaultMaterial.SAPLING)) {
                this.saplingType = null;
                return;
            }
            SaplingType bigSaplingType = this.getBigSaplingType(this.material.getBlockData());
            if (bigSaplingType != null && this.findFourSaplings()) {
                this.saplingType = bigSaplingType;
                return;
            }
            this.saplingType = this.getSmallSaplingType(this.material.getBlockData());
        }

        private boolean findFourSaplings() {
            for (int treeOffsetX = 0; treeOffsetX >= -1; --treeOffsetX) {
                for (int treeOffsetZ = 0; treeOffsetZ >= -1; --treeOffsetZ) {
                    if (!this.isSameSapling(this.material, this.world.getMaterial(this.x + treeOffsetX, this.y, this.z + treeOffsetZ)) || !this.isSameSapling(this.material, this.world.getMaterial(this.x + treeOffsetX + 1, this.y, this.z + treeOffsetZ)) || !this.isSameSapling(this.material, this.world.getMaterial(this.x + treeOffsetX, this.y, this.z + treeOffsetZ + 1)) || !this.isSameSapling(this.material, this.world.getMaterial(this.x + treeOffsetX + 1, this.y, this.z + treeOffsetZ + 1))) continue;
                    this.x += treeOffsetX;
                    this.z += treeOffsetZ;
                    return true;
                }
            }
            return false;
        }

        private boolean isSameSapling(LocalMaterialData sapling1, LocalMaterialData sapling2) {
            return sapling1.isMaterial(DefaultMaterial.SAPLING) && sapling2.isMaterial(DefaultMaterial.SAPLING) && sapling1.getBlockData() % 8 == sapling2.getBlockData() % 8;
        }

        private SaplingType getSmallSaplingType(int data) {
            switch (data % 8) {
                case 0: {
                    return SaplingType.Oak;
                }
                case 1: {
                    return SaplingType.Redwood;
                }
                case 2: {
                    return SaplingType.Birch;
                }
                case 3: {
                    return SaplingType.SmallJungle;
                }
                case 4: {
                    return SaplingType.Acacia;
                }
            }
            return null;
        }

        private SaplingType getBigSaplingType(int data) {
            switch (data % 8) {
                case 1: {
                    return SaplingType.HugeRedwood;
                }
                case 3: {
                    return SaplingType.BigJungle;
                }
                case 5: {
                    return SaplingType.DarkOak;
                }
            }
            return null;
        }
    }
}

