/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.ConfigProvider;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.generator.noise.NoiseGeneratorNewOctaves;
import com.khorn.terraincontrol.generator.resource.Resource;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import java.util.Random;

public class ObjectSpawner {
    private final ConfigProvider configProvider;
    private final Random rand;
    private final LocalWorld world;
    private final NoiseGeneratorNewOctaves noiseGen;
    private double[] reusableChunkNoiseArray;

    public ObjectSpawner(ConfigProvider configProvider, LocalWorld localWorld) {
        this.configProvider = configProvider;
        this.rand = new Random();
        this.world = localWorld;
        this.noiseGen = new NoiseGeneratorNewOctaves(new Random(this.world.getSeed()), 4);
    }

    public void populate(ChunkCoordinate chunkCoord) {
        int z;
        int x = chunkCoord.getChunkX() * 16;
        LocalBiome biome = this.world.getBiome(x + 15, (z = chunkCoord.getChunkZ() * 16) + 15);
        if (biome == null) {
            TerrainControl.log(LogMarker.DEBUG, "Unknown biome at {},{}  (chunk {}). Population failed.", x + 15, z + 15, chunkCoord);
            return;
        }
        BiomeConfig biomeConfig = biome.getBiomeConfig();
        WorldConfig worldConfig = this.configProvider.getWorldConfig();
        long resourcesSeed = worldConfig.resourcesSeed != 0L ? worldConfig.resourcesSeed : this.world.getSeed();
        this.rand.setSeed(resourcesSeed);
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        long l2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkCoord.getChunkX() * l1 + (long)chunkCoord.getChunkZ() * l2 ^ resourcesSeed);
        boolean hasGeneratedAVillage = this.world.placeDefaultStructures(this.rand, chunkCoord);
        this.world.startPopulation(chunkCoord);
        TerrainControl.firePopulationStartEvent(this.world, this.rand, hasGeneratedAVillage, chunkCoord);
        this.placeComplexSurfaceBlocks(chunkCoord);
        for (Resource res : biomeConfig.resourceSequence) {
            res.process(this.world, this.rand, hasGeneratedAVillage, chunkCoord);
        }
        this.world.placePopulationMobs(biome, this.rand, chunkCoord);
        this.freezeChunk(chunkCoord);
        this.world.replaceBlocks(chunkCoord);
        TerrainControl.firePopulationEndEvent(this.world, this.rand, hasGeneratedAVillage, chunkCoord);
        this.world.endPopulation();
    }

    protected void placeComplexSurfaceBlocks(ChunkCoordinate chunkCoord) {
        this.reusableChunkNoiseArray = this.noiseGen.a(this.reusableChunkNoiseArray, chunkCoord.getChunkX() * 16, chunkCoord.getChunkZ() * 16, 16, 16, 0.0625, 0.0625, 1.0);
        int x = chunkCoord.getBlockXCenter();
        int z = chunkCoord.getBlockZCenter();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int blockToReplaceX = x + i;
                int blockToReplaceZ = z + j;
                LocalBiome biome = this.world.getBiome(blockToReplaceX, blockToReplaceZ);
                if (biome == null) continue;
                double noise = this.reusableChunkNoiseArray[i + j * 16];
                BiomeConfig biomeConfig = biome.getBiomeConfig();
                biomeConfig.surfaceAndGroundControl.spawn(this.world, biomeConfig, noise, blockToReplaceX, blockToReplaceZ);
            }
        }
    }

    protected void freezeChunk(ChunkCoordinate chunkCoord) {
        LocalMaterialData snowMaterial = TerrainControl.toLocalMaterialData(DefaultMaterial.SNOW, 0);
        int x = chunkCoord.getChunkX() * 16 + 8;
        int z = chunkCoord.getChunkZ() * 16 + 8;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int blockToFreezeX = x + i;
                int blockToFreezeZ = z + j;
                this.freezeColumn(blockToFreezeX, blockToFreezeZ, snowMaterial);
            }
        }
    }

    protected void freezeColumn(int x, int z, LocalMaterialData snowMaterial) {
        LocalBiome biome = this.world.getBiome(x, z);
        if (biome != null) {
            BiomeConfig biomeConfig = biome.getBiomeConfig();
            int blockToFreezeY = this.world.getHighestBlockYAt(x, z);
            if (blockToFreezeY > 0 && biome.getTemperatureAt(x, blockToFreezeY, z) < 0.15f) {
                if (this.world.getMaterial(x, blockToFreezeY - 1, z).isLiquid()) {
                    this.world.setBlock(x, blockToFreezeY - 1, z, biomeConfig.iceBlock);
                } else if (this.world.isEmpty(x, blockToFreezeY, z) && this.world.getMaterial(x, blockToFreezeY - 1, z).canSnowFallOn()) {
                    this.world.setBlock(x, blockToFreezeY, z, snowMaterial);
                }
            }
        }
    }
}

