/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.biome;

import com.khorn.terraincontrol.generator.biome.OutputType;
import java.util.ArrayList;

public class ArraysCache {
    private final int[][] smallArrays = new int[128][];
    private int smallArraysNext = 0;
    private final ArrayList<int[]> bigArrays = new ArrayList();
    private int bigArraysNext = 0;
    public boolean isFree = true;
    public OutputType outputType = OutputType.FULL;

    public void release() {
        this.smallArraysNext = 0;
        this.bigArraysNext = 0;
        this.isFree = true;
        this.outputType = OutputType.FULL;
    }

    public int[] getArray(int size) {
        int[] array;
        if (size <= 256) {
            int[] array2 = this.smallArrays[this.smallArraysNext];
            if (array2 == null) {
                array2 = new int[256];
                this.smallArrays[this.smallArraysNext] = array2;
            }
            ++this.smallArraysNext;
            return array2;
        }
        if (this.bigArraysNext == this.bigArrays.size()) {
            array = new int[size];
            this.bigArrays.add(array);
        } else {
            array = this.bigArrays.get(this.bigArraysNext);
            if (array.length < size) {
                array = new int[size];
                this.bigArrays.set(this.bigArraysNext, array);
            }
        }
        ++this.bigArraysNext;
        return array;
    }
}

