/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.biome.layers;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.generator.biome.ArraysCache;
import com.khorn.terraincontrol.generator.biome.layers.Layer;

public class LayerBiomeInBiome
extends Layer {
    public LocalBiome biome;
    public int chance = 10;
    public boolean inOcean = false;
    public boolean[] biomeIsles = new boolean[1024];

    public LayerBiomeInBiome(long seed, Layer childLayer) {
        super(seed);
        this.child = childLayer;
        for (int i = 0; i < this.biomeIsles.length; ++i) {
            this.biomeIsles[i] = false;
        }
    }

    @Override
    public int[] getInts(ArraysCache cache, int x, int z, int xSize, int zSize) {
        int x0 = x - 1;
        int z0 = z - 1;
        int xSize0 = xSize + 2;
        int zSize0 = zSize + 2;
        int[] childInts = this.child.getInts(cache, x0, z0, xSize0, zSize0);
        int[] thisInts = cache.getArray(xSize * zSize);
        for (int zi = 0; zi < zSize; ++zi) {
            for (int xi = 0; xi < xSize; ++xi) {
                int seCheck;
                int swCheck;
                int neCheck;
                int nwCheck;
                this.initChunkSeed(xi + x, zi + z);
                int selection = childInts[xi + 1 + (zi + 1) * xSize0];
                boolean spawn = false;
                if (this.inOcean) {
                    nwCheck = childInts[xi + 0 + zi * xSize0] & 0x400;
                    neCheck = childInts[xi + 2 + zi * xSize0] & 0x400;
                    swCheck = childInts[xi + 0 + (zi + 2) * xSize0] & 0x400;
                    seCheck = childInts[xi + 2 + (zi + 2) * xSize0] & 0x400;
                    if ((selection & 0x400) == 0 && nwCheck == 0 && neCheck == 0 && swCheck == 0 && seCheck == 0 && this.nextInt(this.chance) == 0) {
                        selection = selection & 0x800 | selection & 0x3000 | 0x400 | this.biome.getIds().getGenerationId() | 0x4000;
                        spawn = true;
                    }
                }
                if (!spawn) {
                    nwCheck = childInts[xi + 0 + zi * xSize0] & 0x3FF;
                    neCheck = childInts[xi + 2 + zi * xSize0] & 0x3FF;
                    swCheck = childInts[xi + 0 + (zi + 2) * xSize0] & 0x3FF;
                    seCheck = childInts[xi + 2 + (zi + 2) * xSize0] & 0x3FF;
                    if (this.biomeIsles[selection & 0x3FF] && this.biomeIsles[nwCheck] && this.biomeIsles[neCheck] && this.biomeIsles[swCheck] && this.biomeIsles[seCheck] && this.nextInt(this.chance) == 0) {
                        selection = selection & 0x400 | selection & 0x800 | selection & 0x3000 | this.biome.getIds().getGenerationId() | 0x4000;
                    }
                }
                thisInts[xi + zi * xSize] = selection;
            }
        }
        return thisInts;
    }
}

