/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.resource;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.generator.resource.Resource;
import com.khorn.terraincontrol.util.MaterialSet;
import java.util.List;
import java.util.Random;

public class CactusGen
extends Resource {
    private int minAltitude;
    private int maxAltitude;
    private MaterialSet sourceBlocks;

    @Override
    public void spawn(LocalWorld world, Random rand, boolean villageInChunk, int x, int z) {
        int y = rand.nextInt(this.maxAltitude - this.minAltitude) + this.minAltitude;
        for (int i = 0; i < 10; ++i) {
            LocalMaterialData foundationMaterial;
            int cactusZ;
            int cactusBaseY;
            int cactusX = x + rand.nextInt(8) - rand.nextInt(8);
            if (!world.isEmpty(cactusX, cactusBaseY = y + rand.nextInt(4) - rand.nextInt(4), cactusZ = z + rand.nextInt(8) - rand.nextInt(8)) || !this.sourceBlocks.contains(foundationMaterial = world.getMaterial(cactusX, cactusBaseY - 1, cactusZ)) || !world.isEmpty(cactusX - 1, cactusBaseY, cactusZ) || !world.isEmpty(cactusX + 1, cactusBaseY, cactusZ) || !world.isEmpty(cactusX, cactusBaseY, cactusZ + 1) || !world.isEmpty(cactusX, cactusBaseY, cactusZ + 1)) continue;
            int cactusHeight = 1 + rand.nextInt(rand.nextInt(3) + 1);
            for (int dY = 0; dY < cactusHeight; ++dY) {
                world.setBlock(cactusX, cactusBaseY + dY, cactusZ, this.material);
            }
        }
    }

    @Override
    public String makeString() {
        return "Cactus(" + this.material + "," + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + this.makeMaterials(this.sourceBlocks) + ")";
    }

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(6, args);
        this.material = this.readMaterial(args.get(0));
        this.frequency = this.readInt(args.get(1), 1, 100);
        this.rarity = this.readRarity(args.get(2));
        this.minAltitude = this.readInt(args.get(3), 0, 256);
        this.maxAltitude = this.readInt(args.get(4), this.minAltitude + 1, 256);
        this.sourceBlocks = this.readMaterials(args, 5);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + super.hashCode();
        hash = 79 * hash + this.minAltitude;
        hash = 79 * hash + this.maxAltitude;
        hash = 79 * hash + (this.sourceBlocks != null ? this.sourceBlocks.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        CactusGen compare = (CactusGen)other;
        return this.minAltitude == compare.minAltitude && this.maxAltitude == compare.maxAltitude && (this.sourceBlocks == null ? this.sourceBlocks == compare.sourceBlocks : this.sourceBlocks.equals(compare.sourceBlocks));
    }
}

