/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.resource;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.generator.resource.Resource;
import java.util.List;
import java.util.Random;

public class DungeonGen
extends Resource {
    private int minAltitude;
    private int maxAltitude;

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(4, args);
        this.frequency = this.readInt(args.get(0), 1, 100);
        this.rarity = this.readRarity(args.get(1));
        this.minAltitude = this.readInt(args.get(2), 0, 256);
        this.maxAltitude = this.readInt(args.get(3), this.minAltitude + 1, 256);
    }

    @Override
    public void spawn(LocalWorld world, Random random, boolean villageInChunk, int x, int z) {
        int y = random.nextInt(this.maxAltitude - this.minAltitude) + this.minAltitude;
        world.PlaceDungeons(random, x, y, z);
    }

    @Override
    public String makeString() {
        return "Dungeon(" + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + ")";
    }

    @Override
    public boolean isAnalogousTo(ConfigFunction<BiomeConfig> other) {
        return this.getClass() == other.getClass();
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + super.hashCode();
        hash = 61 * hash + this.minAltitude;
        hash = 61 * hash + this.maxAltitude;
        return hash;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        DungeonGen compare = (DungeonGen)other;
        return this.minAltitude == compare.minAltitude && this.maxAltitude == compare.maxAltitude;
    }
}

