/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.logging;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class LogMarker {
    public static final Marker FATAL = MarkerManager.getMarker((String)"com.khorn.terraincontrol.FATAL");
    public static final Marker ERROR = MarkerManager.getMarker((String)"com.khorn.terraincontrol.ERROR", (Marker)FATAL);
    public static final Marker WARN = MarkerManager.getMarker((String)"com.khorn.terraincontrol.WARN", (Marker)ERROR);
    public static final Marker INFO = MarkerManager.getMarker((String)"com.khorn.terraincontrol.INFO", (Marker)WARN);
    public static final Marker DEBUG = MarkerManager.getMarker((String)"com.khorn.terraincontrol.DEBUG", (Marker)INFO);
    public static final Marker TRACE = MarkerManager.getMarker((String)"com.khorn.terraincontrol.TRACE", (Marker)DEBUG);
    private static Map<Marker, Integer> standardLevels = new LinkedHashMap<Marker, Integer>(6);

    private LogMarker() {
    }

    public static int compare(Marker first, Marker second) {
        Integer firstInt = standardLevels.get(first);
        if (firstInt != null) {
            return standardLevels.get(first).compareTo(standardLevels.get(second));
        }
        return 0;
    }

    static {
        standardLevels.put(FATAL, Level.FATAL.intLevel());
        standardLevels.put(ERROR, Level.ERROR.intLevel());
        standardLevels.put(WARN, Level.WARN.intLevel());
        standardLevels.put(INFO, Level.INFO.intLevel());
        standardLevels.put(DEBUG, Level.DEBUG.intLevel());
        standardLevels.put(TRACE, Level.TRACE.intLevel());
    }
}

